/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp.reader;

import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.rtsp.RtpPacket;
import androidx.media3.exoplayer.rtsp.RtpPayloadFormat;
import androidx.media3.exoplayer.rtsp.reader.RtpPayloadReader;
import androidx.media3.exoplayer.rtsp.reader.RtpReaderUtils;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpVp8Reader
implements RtpPayloadReader {
    private static final String TAG = "RtpVP8Reader";
    private static final int MEDIA_CLOCK_FREQUENCY = 90000;
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private int previousSequenceNumber;
    private int fragmentedSampleSizeBytes;
    private long fragmentedSampleTimeUs;
    private long startTimeOffsetUs;
    private boolean gotFirstPacketOfVp8Frame;
    private boolean isKeyFrame;
    private boolean isOutputFormatSet;

    public RtpVp8Reader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.previousSequenceNumber = -1;
        this.fragmentedSampleSizeBytes = -1;
        this.fragmentedSampleTimeUs = -9223372036854775807L;
        this.startTimeOffsetUs = 0L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 2);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
        Assertions.checkState((this.firstReceivedTimestamp == -9223372036854775807L ? 1 : 0) != 0);
        this.firstReceivedTimestamp = timestamp;
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        boolean isValidVP8Descriptor = this.validateVp8Descriptor(data, sequenceNumber);
        if (isValidVP8Descriptor) {
            if (this.fragmentedSampleSizeBytes == -1 && this.gotFirstPacketOfVp8Frame) {
                boolean bl = this.isKeyFrame = (data.peekUnsignedByte() & 1) == 0;
            }
            if (!this.isOutputFormatSet) {
                int currPosition = data.getPosition();
                data.setPosition(currPosition + 6);
                int width = data.readLittleEndianUnsignedShort() & 0x3FFF;
                int height = data.readLittleEndianUnsignedShort() & 0x3FFF;
                data.setPosition(currPosition);
                if (width != this.payloadFormat.format.width || height != this.payloadFormat.format.height) {
                    this.trackOutput.format(this.payloadFormat.format.buildUpon().setWidth(width).setHeight(height).build());
                }
                this.isOutputFormatSet = true;
            }
            int fragmentSize = data.bytesLeft();
            this.trackOutput.sampleData(data, fragmentSize);
            this.fragmentedSampleSizeBytes = this.fragmentedSampleSizeBytes == -1 ? fragmentSize : (this.fragmentedSampleSizeBytes += fragmentSize);
            this.fragmentedSampleTimeUs = RtpReaderUtils.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp, 90000);
            if (rtpMarker) {
                this.outputSampleMetadataForFragmentedPackets();
            }
            this.previousSequenceNumber = sequenceNumber;
        }
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.fragmentedSampleSizeBytes = -1;
        this.startTimeOffsetUs = timeUs;
    }

    private boolean validateVp8Descriptor(ParsableByteArray payload, int packetSequenceNumber) {
        int header = payload.readUnsignedByte();
        if ((header & 0x10) == 16 && (header & 7) == 0) {
            if (this.gotFirstPacketOfVp8Frame && this.fragmentedSampleSizeBytes > 0) {
                this.outputSampleMetadataForFragmentedPackets();
            }
            this.gotFirstPacketOfVp8Frame = true;
        } else if (this.gotFirstPacketOfVp8Frame) {
            int expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber);
            if (packetSequenceNumber < expectedSequenceNumber) {
                Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d. Dropping packet.", (Object[])new Object[]{expectedSequenceNumber, packetSequenceNumber}));
                return false;
            }
        } else {
            Log.w((String)TAG, (String)"RTP packet is not the start of a new VP8 partition, skipping.");
            return false;
        }
        if ((header & 0x80) != 0) {
            int iHeader;
            int xHeader = payload.readUnsignedByte();
            if ((xHeader & 0x80) != 0 && ((iHeader = payload.readUnsignedByte()) & 0x80) != 0) {
                payload.skipBytes(1);
            }
            if ((xHeader & 0x40) != 0) {
                payload.skipBytes(1);
            }
            if ((xHeader & 0x20) != 0 || (xHeader & 0x10) != 0) {
                payload.skipBytes(1);
            }
        }
        return true;
    }

    private void outputSampleMetadataForFragmentedPackets() {
        ((TrackOutput)Assertions.checkNotNull((Object)this.trackOutput)).sampleMetadata(this.fragmentedSampleTimeUs, this.isKeyFrame ? 1 : 0, this.fragmentedSampleSizeBytes, 0, null);
        this.fragmentedSampleSizeBytes = -1;
        this.fragmentedSampleTimeUs = -9223372036854775807L;
        this.gotFirstPacketOfVp8Frame = false;
    }
}

