/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.Audio360JNI;
import com.twobigears.audio360.AudioFormat;
import com.twobigears.audio360.AudioFormatQuality;
import com.twobigears.audio360.EngineError;
import com.twobigears.audio360.IOStream;
import java.nio.ByteBuffer;

public class AudioFormatEncoder {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected AudioFormatEncoder(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AudioFormatEncoder obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                Audio360JNI.delete_AudioFormatEncoder(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public long encode(ByteBuffer inputInterleavedAudio, long totalNumSamples, boolean endOfStream) {
        return Audio360JNI.AudioFormatEncoder_encode(this.swigCPtr, this, inputInterleavedAudio, totalNumSamples, endOfStream);
    }

    public AudioFormat getAudioFormat() {
        return AudioFormat.swigToEnum(Audio360JNI.AudioFormatEncoder_getAudioFormat(this.swigCPtr, this));
    }

    public EngineError getQualityIndex(int[] qualityIndex) {
        return EngineError.swigToEnum(Audio360JNI.AudioFormatEncoder_getQualityIndex(this.swigCPtr, this, qualityIndex));
    }

    public EngineError getBitRate(int[] bitRate) {
        return EngineError.swigToEnum(Audio360JNI.AudioFormatEncoder_getBitRate(this.swigCPtr, this, bitRate));
    }

    public float getOutputSampleRate() {
        return Audio360JNI.AudioFormatEncoder_getOutputSampleRate(this.swigCPtr, this);
    }

    public int getNumOfChannels() {
        return Audio360JNI.AudioFormatEncoder_getNumOfChannels(this.swigCPtr, this);
    }

    public long getMaxBufferSize() {
        return Audio360JNI.AudioFormatEncoder_getMaxBufferSize(this.swigCPtr, this);
    }

    public static EngineError getBitRateForQualityIndex(AudioFormat format, int qualityIndex, int[] bitRate) {
        return EngineError.swigToEnum(Audio360JNI.AudioFormatEncoder_getBitRateForQualityIndex(format.swigValue(), qualityIndex, bitRate));
    }

    public static EngineError getIndexForQuality(AudioFormat format, AudioFormatQuality quality, int[] qualityIndex) {
        return EngineError.swigToEnum(Audio360JNI.AudioFormatEncoder_getIndexForQuality(format.swigValue(), quality.swigValue(), qualityIndex));
    }

    public static AudioFormatEncoder create(IOStream outputStream, AudioFormat format, float inputSampleRate, float outputSampleRate, long maxBufferSize, int numChannels, AudioFormatQuality quality) {
        long cPtr = Audio360JNI.AudioFormatEncoder_create(IOStream.getCPtr(outputStream), outputStream, format.swigValue(), inputSampleRate, outputSampleRate, maxBufferSize, numChannels, quality.swigValue());
        return cPtr == 0L ? null : new AudioFormatEncoder(cPtr, true);
    }
}

