/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.smoothstreaming.offline;

import android.net.Uri;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.exoplayer.offline.SegmentDownloader;
import androidx.media3.exoplayer.smoothstreaming.manifest.SsManifest;
import androidx.media3.exoplayer.smoothstreaming.manifest.SsManifestParser;
import androidx.media3.exoplayer.upstream.ParsingLoadable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

@UnstableApi
public final class SsDownloader
extends SegmentDownloader<SsManifest> {
    public SsDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory) {
        this(mediaItem, cacheDataSourceFactory, Runnable::run);
    }

    public SsDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this(mediaItem.buildUpon().setUri(Util.fixSmoothStreamingIsmManifestUri((Uri)((MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)mediaItem.localConfiguration)).uri)).build(), new SsManifestParser(), cacheDataSourceFactory, executor, 20000L);
    }

    @Deprecated
    public SsDownloader(MediaItem mediaItem, ParsingLoadable.Parser<SsManifest> manifestParser, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this(mediaItem, manifestParser, cacheDataSourceFactory, executor, 20000L);
    }

    public SsDownloader(MediaItem mediaItem, ParsingLoadable.Parser<SsManifest> manifestParser, CacheDataSource.Factory cacheDataSourceFactory, Executor executor, long maxMergedSegmentStartTimeDiffMs) {
        super(mediaItem, manifestParser, cacheDataSourceFactory, executor, maxMergedSegmentStartTimeDiffMs);
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, SsManifest manifest, boolean removing) {
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (SsManifest.StreamElement streamElement : manifest.streamElements) {
            for (int i = 0; i < streamElement.formats.length; ++i) {
                for (int j = 0; j < streamElement.chunkCount; ++j) {
                    segments.add(new SegmentDownloader.Segment(streamElement.getStartTimeUs(j), new DataSpec(streamElement.buildRequestUri(i, j))));
                }
            }
        }
        return segments;
    }
}

