/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.trackselection;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.trackselection.TrackSelectorResult;
import androidx.media3.exoplayer.upstream.BandwidthMeter;

@UnstableApi
public abstract class TrackSelector {
    @Nullable
    private InvalidationListener listener;
    @Nullable
    private BandwidthMeter bandwidthMeter;

    @CallSuper
    public void init(InvalidationListener listener, BandwidthMeter bandwidthMeter) {
        this.listener = listener;
        this.bandwidthMeter = bandwidthMeter;
    }

    @CallSuper
    public void release() {
        this.listener = null;
        this.bandwidthMeter = null;
    }

    public abstract TrackSelectorResult selectTracks(RendererCapabilities[] var1, TrackGroupArray var2, MediaSource.MediaPeriodId var3, Timeline var4) throws ExoPlaybackException;

    public abstract void onSelectionActivated(@Nullable Object var1);

    public TrackSelectionParameters getParameters() {
        return TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT;
    }

    public void setParameters(TrackSelectionParameters parameters) {
    }

    public boolean isSetParametersSupported() {
        return false;
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) {
    }

    @Nullable
    public RendererCapabilities.Listener getRendererCapabilitiesListener() {
        return null;
    }

    protected final void invalidate() {
        if (this.listener != null) {
            this.listener.onTrackSelectionsInvalidated();
        }
    }

    protected final void invalidateForRendererCapabilitiesChange(Renderer renderer) {
        if (this.listener != null) {
            this.listener.onRendererCapabilitiesChanged(renderer);
        }
    }

    protected final BandwidthMeter getBandwidthMeter() {
        return (BandwidthMeter)Assertions.checkStateNotNull((Object)this.bandwidthMeter);
    }

    public static interface InvalidationListener {
        public void onTrackSelectionsInvalidated();

        default public void onRendererCapabilitiesChanged(Renderer renderer) {
        }
    }
}

