/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.EGLSurfaceTexture;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@RequiresApi(value=17)
@UnstableApi
public final class PlaceholderSurface
extends Surface {
    private static final String TAG = "PlaceholderSurface";
    public final boolean secure;
    private static int secureMode;
    private static boolean secureModeInitialized;
    private final PlaceholderSurfaceThread thread;
    private boolean threadReleased;

    public static synchronized boolean isSecureSupported(Context context) {
        if (!secureModeInitialized) {
            secureMode = PlaceholderSurface.getSecureMode(context);
            secureModeInitialized = true;
        }
        return secureMode != 0;
    }

    public static PlaceholderSurface newInstanceV17(Context context, boolean secure) {
        Assertions.checkState((!secure || PlaceholderSurface.isSecureSupported(context) ? 1 : 0) != 0);
        PlaceholderSurfaceThread thread = new PlaceholderSurfaceThread();
        return thread.init(secure ? secureMode : 0);
    }

    private PlaceholderSurface(PlaceholderSurfaceThread thread, SurfaceTexture surfaceTexture, boolean secure) {
        super(surfaceTexture);
        this.thread = thread;
        this.secure = secure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        super.release();
        PlaceholderSurfaceThread placeholderSurfaceThread = this.thread;
        synchronized (placeholderSurfaceThread) {
            if (!this.threadReleased) {
                this.thread.release();
                this.threadReleased = true;
            }
        }
    }

    private static int getSecureMode(Context context) {
        if (GlUtil.isProtectedContentExtensionSupported((Context)context)) {
            if (GlUtil.isSurfacelessContextExtensionSupported()) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private static class PlaceholderSurfaceThread
    extends HandlerThread
    implements Handler.Callback {
        private static final int MSG_INIT = 1;
        private static final int MSG_RELEASE = 2;
        private @MonotonicNonNull EGLSurfaceTexture eglSurfaceTexture;
        private @MonotonicNonNull Handler handler;
        @Nullable
        private Error initError;
        @Nullable
        private RuntimeException initException;
        @Nullable
        private PlaceholderSurface surface;

        public PlaceholderSurfaceThread() {
            super("ExoPlayer:PlaceholderSurface");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PlaceholderSurface init(int secureMode) {
            this.start();
            this.handler = new Handler(this.getLooper(), (Handler.Callback)this);
            this.eglSurfaceTexture = new EGLSurfaceTexture(this.handler);
            boolean wasInterrupted = false;
            PlaceholderSurfaceThread placeholderSurfaceThread = this;
            synchronized (placeholderSurfaceThread) {
                this.handler.obtainMessage(1, secureMode, 0).sendToTarget();
                while (this.surface == null && this.initException == null && this.initError == null) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                    }
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.initException != null) {
                throw this.initException;
            }
            if (this.initError != null) {
                throw this.initError;
            }
            return (PlaceholderSurface)((Object)Assertions.checkNotNull((Object)((Object)this.surface)));
        }

        public void release() {
            Assertions.checkNotNull((Object)this.handler);
            this.handler.sendEmptyMessage(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    try {
                        this.initInternal(msg.arg1);
                    }
                    catch (RuntimeException e) {
                        Log.e((String)PlaceholderSurface.TAG, (String)"Failed to initialize placeholder surface", (Throwable)e);
                        this.initException = e;
                    }
                    catch (GlUtil.GlException e) {
                        Log.e((String)PlaceholderSurface.TAG, (String)"Failed to initialize placeholder surface", (Throwable)e);
                        this.initException = new IllegalStateException(e);
                    }
                    catch (Error e) {
                        Log.e((String)PlaceholderSurface.TAG, (String)"Failed to initialize placeholder surface", (Throwable)e);
                        this.initError = e;
                    }
                    finally {
                        PlaceholderSurfaceThread e = this;
                        synchronized (e) {
                            ((Object)((Object)this)).notify();
                        }
                    }
                    return true;
                }
                case 2: {
                    try {
                        this.releaseInternal();
                    }
                    catch (Throwable e) {
                        Log.e((String)PlaceholderSurface.TAG, (String)"Failed to release placeholder surface", (Throwable)e);
                    }
                    finally {
                        this.quit();
                    }
                    return true;
                }
            }
            return true;
        }

        private void initInternal(int secureMode) throws GlUtil.GlException {
            Assertions.checkNotNull((Object)this.eglSurfaceTexture);
            this.eglSurfaceTexture.init(secureMode);
            this.surface = new PlaceholderSurface(this, this.eglSurfaceTexture.getSurfaceTexture(), secureMode != 0);
        }

        private void releaseInternal() {
            Assertions.checkNotNull((Object)this.eglSurfaceTexture);
            this.eglSurfaceTexture.release();
        }
    }
}

