/*
 * Decompiled with CFR 0.152.
 */
package com.android.vending.expansion.zipfile;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import com.android.vending.expansion.zipfile.APKExpansionSupport;
import com.android.vending.expansion.zipfile.ZipResourceFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public abstract class APEZProvider
extends ContentProvider {
    private ZipResourceFile mAPKExtensionFile;
    private boolean mInit;
    public static final String FILEID = "_id";
    public static final String FILENAME = "ZPFN";
    public static final String ZIPFILE = "ZFIL";
    public static final String MODIFICATION = "ZMOD";
    public static final String CRC32 = "ZCRC";
    public static final String COMPRESSEDLEN = "ZCOL";
    public static final String UNCOMPRESSEDLEN = "ZUNL";
    public static final String COMPRESSIONTYPE = "ZTYP";
    public static final String[] ALL_FIELDS = new String[]{"_id", "ZPFN", "ZFIL", "ZMOD", "ZCRC", "ZCOL", "ZUNL", "ZTYP"};
    public static final int FILEID_IDX = 0;
    public static final int FILENAME_IDX = 1;
    public static final int ZIPFILE_IDX = 2;
    public static final int MOD_IDX = 3;
    public static final int CRC_IDX = 4;
    public static final int COMPLEN_IDX = 5;
    public static final int UNCOMPLEN_IDX = 6;
    public static final int COMPTYPE_IDX = 7;
    public static final int[] ALL_FIELDS_INT;
    private static final String NO_FILE = "N";

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        ALL_FIELDS_INT = nArray;
    }

    public abstract String getAuthority();

    public int delete(Uri arg0, String arg1, String[] arg2) {
        return 0;
    }

    public String getType(Uri uri) {
        return "vnd.android.cursor.item/asset";
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    private boolean initIfNecessary() {
        if (!this.mInit) {
            int patchFileVersion;
            int mainFileVersion;
            PackageInfo packInfo;
            Context ctx = this.getContext();
            PackageManager pm = ctx.getPackageManager();
            ProviderInfo pi = pm.resolveContentProvider(this.getAuthority(), 128);
            try {
                packInfo = pm.getPackageInfo(ctx.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e1) {
                e1.printStackTrace();
                return false;
            }
            int appVersionCode = packInfo.versionCode;
            String[] resourceFiles = null;
            if (pi.metaData != null) {
                mainFileVersion = pi.metaData.getInt("mainVersion", appVersionCode);
                patchFileVersion = pi.metaData.getInt("patchVersion", appVersionCode);
                String mainFileName = pi.metaData.getString("mainFilename", NO_FILE);
                if (NO_FILE != mainFileName) {
                    String patchFileName = pi.metaData.getString("patchFilename", NO_FILE);
                    resourceFiles = NO_FILE != patchFileName ? new String[]{mainFileName, patchFileName} : new String[]{mainFileName};
                }
            } else {
                mainFileVersion = patchFileVersion = appVersionCode;
            }
            try {
                this.mAPKExtensionFile = resourceFiles == null ? APKExpansionSupport.getAPKExpansionZipFile(ctx, mainFileVersion, patchFileVersion) : APKExpansionSupport.getResourceZipFile(resourceFiles);
                this.mInit = true;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean onCreate() {
        return true;
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        this.initIfNecessary();
        String path = uri.getEncodedPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.mAPKExtensionFile.getAssetFileDescriptor(path);
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        this.initIfNecessary();
        return super.applyBatch(operations);
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        this.initIfNecessary();
        AssetFileDescriptor af = this.openAssetFile(uri, mode);
        if (af != null) {
            return af.getParcelFileDescriptor();
        }
        return null;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        int[] intProjection;
        this.initIfNecessary();
        ZipResourceFile.ZipEntryRO[] zipEntries = this.mAPKExtensionFile == null ? new ZipResourceFile.ZipEntryRO[]{} : this.mAPKExtensionFile.getAllEntries();
        if (projection == null) {
            intProjection = ALL_FIELDS_INT;
            projection = ALL_FIELDS;
        } else {
            int len = projection.length;
            intProjection = new int[len];
            int i = 0;
            while (i < len) {
                if (projection[i].equals(FILEID)) {
                    intProjection[i] = 0;
                } else if (projection[i].equals(FILENAME)) {
                    intProjection[i] = 1;
                } else if (projection[i].equals(ZIPFILE)) {
                    intProjection[i] = 2;
                } else if (projection[i].equals(MODIFICATION)) {
                    intProjection[i] = 3;
                } else if (projection[i].equals(CRC32)) {
                    intProjection[i] = 4;
                } else if (projection[i].equals(COMPRESSEDLEN)) {
                    intProjection[i] = 5;
                } else if (projection[i].equals(UNCOMPRESSEDLEN)) {
                    intProjection[i] = 6;
                } else if (projection[i].equals(COMPRESSIONTYPE)) {
                    intProjection[i] = 7;
                } else {
                    throw new RuntimeException();
                }
                ++i;
            }
        }
        MatrixCursor mc = new MatrixCursor(projection, zipEntries.length);
        int len = intProjection.length;
        ZipResourceFile.ZipEntryRO[] zipEntryROArray = zipEntries;
        int n = zipEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ZipResourceFile.ZipEntryRO zer = zipEntryROArray[n2];
            MatrixCursor.RowBuilder rb = mc.newRow();
            int i = 0;
            while (i < len) {
                switch (intProjection[i]) {
                    case 0: {
                        rb.add((Object)i);
                        break;
                    }
                    case 1: {
                        rb.add((Object)zer.mFileName);
                        break;
                    }
                    case 2: {
                        rb.add((Object)zer.getZipFileName());
                        break;
                    }
                    case 3: {
                        rb.add((Object)zer.mWhenModified);
                        break;
                    }
                    case 4: {
                        rb.add((Object)zer.mCRC32);
                        break;
                    }
                    case 5: {
                        rb.add((Object)zer.mCompressedLength);
                        break;
                    }
                    case 6: {
                        rb.add((Object)zer.mUncompressedLength);
                        break;
                    }
                    case 7: {
                        rb.add((Object)zer.mMethod);
                    }
                }
                ++i;
            }
            ++n2;
        }
        return mc;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }
}

