/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import android.view.Display;
import android.view.Surface;
import androidx.annotation.CallSuper;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DebugViewProvider;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Effect;
import androidx.media3.common.Format;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.SurfaceInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.VideoFrameProcessor;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.MediaFormatUtil;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.TraceUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.mediacodec.MediaCodecAdapter;
import androidx.media3.exoplayer.mediacodec.MediaCodecDecoderException;
import androidx.media3.exoplayer.mediacodec.MediaCodecInfo;
import androidx.media3.exoplayer.mediacodec.MediaCodecRenderer;
import androidx.media3.exoplayer.mediacodec.MediaCodecSelector;
import androidx.media3.exoplayer.mediacodec.MediaCodecUtil;
import androidx.media3.exoplayer.video.MediaCodecVideoDecoderException;
import androidx.media3.exoplayer.video.PlaceholderSurface;
import androidx.media3.exoplayer.video.VideoFrameMetadataListener;
import androidx.media3.exoplayer.video.VideoFrameReleaseHelper;
import androidx.media3.exoplayer.video.VideoRendererEventListener;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public class MediaCodecVideoRenderer
extends MediaCodecRenderer {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private static final float INITIAL_FORMAT_MAX_INPUT_SIZE_SCALE_FACTOR = 1.5f;
    private static final long TUNNELING_EOS_PRESENTATION_TIME_US = Long.MAX_VALUE;
    private static final int HEVC_MAX_INPUT_SIZE_THRESHOLD = 0x200000;
    private static boolean evaluatedDeviceNeedsSetOutputSurfaceWorkaround;
    private static boolean deviceNeedsSetOutputSurfaceWorkaround;
    private final Context context;
    private final VideoFrameReleaseHelper frameReleaseHelper;
    private final VideoRendererEventListener.EventDispatcher eventDispatcher;
    private final VideoFrameProcessorManager videoFrameProcessorManager;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsNoPostProcessWorkaround;
    private CodecMaxValues codecMaxValues;
    private boolean codecNeedsSetOutputSurfaceWorkaround;
    private boolean codecHandlesHdr10PlusOutOfBandMetadata;
    @Nullable
    private Surface displaySurface;
    @Nullable
    private PlaceholderSurface placeholderSurface;
    private boolean haveReportedFirstFrameRenderedForCurrentSurface;
    private int scalingMode;
    private boolean renderedFirstFrameAfterReset;
    private boolean mayRenderFirstFrameAfterEnableIfNotStarted;
    private boolean renderedFirstFrameAfterEnable;
    private long initialPositionUs;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int buffersInCodecCount;
    private long lastBufferPresentationTimeUs;
    private long lastRenderRealtimeUs;
    private long totalVideoFrameProcessingOffsetUs;
    private int videoFrameProcessingOffsetCount;
    private long lastFrameReleaseTimeNs;
    private VideoSize decodedVideoSize;
    @Nullable
    private VideoSize reportedVideoSize;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    @Nullable
    OnFrameRenderedListenerV23 tunnelingOnFrameRenderedListener;
    @Nullable
    private VideoFrameMetadataListener frameMetadataListener;

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector) {
        this(context, mediaCodecSelector, 0L);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs) {
        this(context, mediaCodecSelector, allowedJoiningTimeMs, null, null, 0);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        this(context, MediaCodecAdapter.Factory.DEFAULT, mediaCodecSelector, allowedJoiningTimeMs, false, eventHandler, eventListener, maxDroppedFramesToNotify, 30.0f);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        this(context, MediaCodecAdapter.Factory.DEFAULT, mediaCodecSelector, allowedJoiningTimeMs, enableDecoderFallback, eventHandler, eventListener, maxDroppedFramesToNotify, 30.0f);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecAdapter.Factory codecAdapterFactory, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        this(context, codecAdapterFactory, mediaCodecSelector, allowedJoiningTimeMs, enableDecoderFallback, eventHandler, eventListener, maxDroppedFramesToNotify, 30.0f);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecAdapter.Factory codecAdapterFactory, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify, float assumedMinimumCodecOperatingRate) {
        super(2, codecAdapterFactory, mediaCodecSelector, enableDecoderFallback, assumedMinimumCodecOperatingRate);
        this.allowedJoiningTimeMs = allowedJoiningTimeMs;
        this.maxDroppedFramesToNotify = maxDroppedFramesToNotify;
        this.context = context.getApplicationContext();
        this.frameReleaseHelper = new VideoFrameReleaseHelper(this.context);
        this.eventDispatcher = new VideoRendererEventListener.EventDispatcher(eventHandler, eventListener);
        this.videoFrameProcessorManager = new VideoFrameProcessorManager(this.frameReleaseHelper, this);
        this.deviceNeedsNoPostProcessWorkaround = MediaCodecVideoRenderer.deviceNeedsNoPostProcessWorkaround();
        this.joiningDeadlineMs = -9223372036854775807L;
        this.scalingMode = 1;
        this.decodedVideoSize = VideoSize.UNKNOWN;
        this.tunnelingAudioSessionId = 0;
        this.clearReportedVideoSize();
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    protected int supportsFormat(MediaCodecSelector mediaCodecSelector, Format format) throws MediaCodecUtil.DecoderQueryException {
        MediaCodecInfo tunnelingDecoderInfo;
        List<MediaCodecInfo> tunnelingDecoderInfos;
        int decoderSupport;
        String mimeType = format.sampleMimeType;
        if (!MimeTypes.isVideo((String)mimeType)) {
            return RendererCapabilities.create(0);
        }
        DrmInitData drmInitData = format.drmInitData;
        boolean requiresSecureDecryption = drmInitData != null;
        List<MediaCodecInfo> decoderInfos = MediaCodecVideoRenderer.getDecoderInfos(this.context, mediaCodecSelector, format, requiresSecureDecryption, false);
        if (requiresSecureDecryption && decoderInfos.isEmpty()) {
            decoderInfos = MediaCodecVideoRenderer.getDecoderInfos(this.context, mediaCodecSelector, format, false, false);
        }
        if (decoderInfos.isEmpty()) {
            return RendererCapabilities.create(1);
        }
        if (!MediaCodecVideoRenderer.supportsFormatDrm(format)) {
            return RendererCapabilities.create(2);
        }
        MediaCodecInfo decoderInfo = decoderInfos.get(0);
        boolean isFormatSupported = decoderInfo.isFormatSupported(format);
        boolean isPreferredDecoder = true;
        if (!isFormatSupported) {
            for (int i = 1; i < decoderInfos.size(); ++i) {
                MediaCodecInfo otherDecoderInfo = decoderInfos.get(i);
                if (!otherDecoderInfo.isFormatSupported(format)) continue;
                decoderInfo = otherDecoderInfo;
                isFormatSupported = true;
                isPreferredDecoder = false;
                break;
            }
        }
        int formatSupport = isFormatSupported ? 4 : 3;
        int adaptiveSupport = decoderInfo.isSeamlessAdaptationSupported(format) ? 16 : 8;
        int hardwareAccelerationSupport = decoderInfo.hardwareAccelerated ? 64 : 0;
        int n = decoderSupport = isPreferredDecoder ? 128 : 0;
        if (Util.SDK_INT >= 26 && "video/dolby-vision".equals(format.sampleMimeType) && !Api26.doesDisplaySupportDolbyVision(this.context)) {
            decoderSupport = 256;
        }
        int tunnelingSupport = 0;
        if (isFormatSupported && !(tunnelingDecoderInfos = MediaCodecVideoRenderer.getDecoderInfos(this.context, mediaCodecSelector, format, requiresSecureDecryption, true)).isEmpty() && (tunnelingDecoderInfo = MediaCodecUtil.getDecoderInfosSortedByFormatSupport(tunnelingDecoderInfos, format).get(0)).isFormatSupported(format) && tunnelingDecoderInfo.isSeamlessAdaptationSupported(format)) {
            tunnelingSupport = 32;
        }
        return RendererCapabilities.create(formatSupport, adaptiveSupport, tunnelingSupport, hardwareAccelerationSupport, decoderSupport);
    }

    @Override
    protected List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        return MediaCodecUtil.getDecoderInfosSortedByFormatSupport(MediaCodecVideoRenderer.getDecoderInfos(this.context, mediaCodecSelector, format, requiresSecureDecoder, this.tunneling), format);
    }

    private static List<MediaCodecInfo> getDecoderInfos(Context context, MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder, boolean requiresTunnelingDecoder) throws MediaCodecUtil.DecoderQueryException {
        List<MediaCodecInfo> alternativeDecoderInfos;
        if (format.sampleMimeType == null) {
            return ImmutableList.of();
        }
        if (Util.SDK_INT >= 26 && "video/dolby-vision".equals(format.sampleMimeType) && !Api26.doesDisplaySupportDolbyVision(context) && !(alternativeDecoderInfos = MediaCodecUtil.getAlternativeDecoderInfos(mediaCodecSelector, format, requiresSecureDecoder, requiresTunnelingDecoder)).isEmpty()) {
            return alternativeDecoderInfos;
        }
        return MediaCodecUtil.getDecoderInfosSoftMatch(mediaCodecSelector, format, requiresSecureDecoder, requiresTunnelingDecoder);
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
        super.onEnabled(joining, mayRenderStartOfStream);
        boolean tunneling = this.getConfiguration().tunneling;
        Assertions.checkState((!tunneling || this.tunnelingAudioSessionId != 0 ? 1 : 0) != 0);
        if (this.tunneling != tunneling) {
            this.tunneling = tunneling;
            this.releaseCodec();
        }
        this.eventDispatcher.enabled(this.decoderCounters);
        this.mayRenderFirstFrameAfterEnableIfNotStarted = mayRenderStartOfStream;
        this.renderedFirstFrameAfterEnable = false;
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        super.onPositionReset(positionUs, joining);
        if (this.videoFrameProcessorManager.isEnabled()) {
            this.videoFrameProcessorManager.flush();
        }
        this.clearRenderedFirstFrame();
        this.frameReleaseHelper.onPositionReset();
        this.lastBufferPresentationTimeUs = -9223372036854775807L;
        this.initialPositionUs = -9223372036854775807L;
        this.consecutiveDroppedFrameCount = 0;
        if (joining) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
    }

    @Override
    public boolean isEnded() {
        boolean isEnded = super.isEnded();
        if (this.videoFrameProcessorManager.isEnabled()) {
            isEnded &= this.videoFrameProcessorManager.releasedLastFrame();
        }
        return isEnded;
    }

    @Override
    public boolean isReady() {
        if (super.isReady() && (!this.videoFrameProcessorManager.isEnabled() || this.videoFrameProcessorManager.isReady()) && (this.renderedFirstFrameAfterReset || this.placeholderSurface != null && this.displaySurface == this.placeholderSurface || this.getCodec() == null || this.tunneling)) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
        this.lastRenderRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
        this.totalVideoFrameProcessingOffsetUs = 0L;
        this.videoFrameProcessingOffsetCount = 0;
        this.frameReleaseHelper.onStarted();
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        this.maybeNotifyVideoFrameProcessingOffset();
        this.frameReleaseHelper.onStopped();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.clearReportedVideoSize();
        this.clearRenderedFirstFrame();
        this.haveReportedFirstFrameRenderedForCurrentSurface = false;
        this.tunnelingOnFrameRenderedListener = null;
        try {
            super.onDisabled();
        }
        finally {
            this.eventDispatcher.disabled(this.decoderCounters);
            this.eventDispatcher.videoSizeChanged(VideoSize.UNKNOWN);
        }
    }

    @Override
    @TargetApi(value=17)
    protected void onReset() {
        try {
            super.onReset();
        }
        finally {
            if (this.videoFrameProcessorManager.isEnabled()) {
                this.videoFrameProcessorManager.reset();
            }
            if (this.placeholderSurface != null) {
                this.releasePlaceholderSurface();
            }
        }
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        switch (messageType) {
            case 1: {
                this.setOutput(message);
                break;
            }
            case 4: {
                this.scalingMode = (Integer)message;
                MediaCodecAdapter codec = this.getCodec();
                if (codec == null) break;
                codec.setVideoScalingMode(this.scalingMode);
                break;
            }
            case 5: {
                this.frameReleaseHelper.setChangeFrameRateStrategy((Integer)message);
                break;
            }
            case 7: {
                this.frameMetadataListener = (VideoFrameMetadataListener)message;
                break;
            }
            case 10: {
                int tunnelingAudioSessionId = (Integer)message;
                if (this.tunnelingAudioSessionId == tunnelingAudioSessionId) break;
                this.tunnelingAudioSessionId = tunnelingAudioSessionId;
                if (!this.tunneling) break;
                this.releaseCodec();
                break;
            }
            case 13: {
                List videoEffects = (List)Assertions.checkNotNull((Object)message);
                this.videoFrameProcessorManager.setVideoEffects(videoEffects);
                break;
            }
            case 14: {
                Size outputResolution = (Size)Assertions.checkNotNull((Object)message);
                if (outputResolution.getWidth() == 0 || outputResolution.getHeight() == 0 || this.displaySurface == null) break;
                this.videoFrameProcessorManager.setOutputSurfaceInfo(this.displaySurface, outputResolution);
                break;
            }
            default: {
                super.handleMessage(messageType, message);
            }
        }
    }

    private void setOutput(@Nullable Object output) throws ExoPlaybackException {
        Surface displaySurface;
        Surface surface = displaySurface = output instanceof Surface ? (Surface)output : null;
        if (displaySurface == null) {
            if (this.placeholderSurface != null) {
                displaySurface = this.placeholderSurface;
            } else {
                MediaCodecInfo codecInfo = this.getCodecInfo();
                if (codecInfo != null && this.shouldUsePlaceholderSurface(codecInfo)) {
                    this.placeholderSurface = PlaceholderSurface.newInstanceV17(this.context, codecInfo.secure);
                    displaySurface = this.placeholderSurface;
                }
            }
        }
        if (this.displaySurface != displaySurface) {
            this.displaySurface = displaySurface;
            this.frameReleaseHelper.onSurfaceChanged(displaySurface);
            this.haveReportedFirstFrameRenderedForCurrentSurface = false;
            int state = this.getState();
            MediaCodecAdapter codec = this.getCodec();
            if (codec != null && !this.videoFrameProcessorManager.isEnabled()) {
                if (Util.SDK_INT >= 23 && displaySurface != null && !this.codecNeedsSetOutputSurfaceWorkaround) {
                    this.setOutputSurfaceV23(codec, displaySurface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodecOrBypass();
                }
            }
            if (displaySurface != null && displaySurface != this.placeholderSurface) {
                this.maybeRenotifyVideoSizeChanged();
                this.clearRenderedFirstFrame();
                if (state == 2) {
                    this.setJoiningDeadlineMs();
                }
                if (this.videoFrameProcessorManager.isEnabled()) {
                    this.videoFrameProcessorManager.setOutputSurfaceInfo(displaySurface, Size.UNKNOWN);
                }
            } else {
                this.clearReportedVideoSize();
                this.clearRenderedFirstFrame();
                if (this.videoFrameProcessorManager.isEnabled()) {
                    this.videoFrameProcessorManager.clearOutputSurfaceInfo();
                }
            }
        } else if (displaySurface != null && displaySurface != this.placeholderSurface) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec(MediaCodecInfo codecInfo) {
        return this.displaySurface != null || this.shouldUsePlaceholderSurface(codecInfo);
    }

    @Override
    protected boolean getCodecNeedsEosPropagation() {
        return this.tunneling && Util.SDK_INT < 23;
    }

    @Override
    @TargetApi(value=17)
    protected MediaCodecAdapter.Configuration getMediaCodecConfiguration(MediaCodecInfo codecInfo, Format format, @Nullable MediaCrypto crypto, float codecOperatingRate) {
        if (this.placeholderSurface != null && this.placeholderSurface.secure != codecInfo.secure) {
            this.releasePlaceholderSurface();
        }
        String codecMimeType = codecInfo.codecMimeType;
        this.codecMaxValues = this.getCodecMaxValues(codecInfo, format, this.getStreamFormats());
        MediaFormat mediaFormat = this.getMediaFormat(format, codecMimeType, this.codecMaxValues, codecOperatingRate, this.deviceNeedsNoPostProcessWorkaround, this.tunneling ? this.tunnelingAudioSessionId : 0);
        if (this.displaySurface == null) {
            if (!this.shouldUsePlaceholderSurface(codecInfo)) {
                throw new IllegalStateException();
            }
            if (this.placeholderSurface == null) {
                this.placeholderSurface = PlaceholderSurface.newInstanceV17(this.context, codecInfo.secure);
            }
            this.displaySurface = this.placeholderSurface;
        }
        if (this.videoFrameProcessorManager.isEnabled()) {
            mediaFormat = this.videoFrameProcessorManager.amendMediaFormatKeys(mediaFormat);
        }
        return MediaCodecAdapter.Configuration.createForVideoDecoding(codecInfo, mediaFormat, format, this.videoFrameProcessorManager.isEnabled() ? this.videoFrameProcessorManager.getInputSurface() : this.displaySurface, crypto);
    }

    @Override
    protected DecoderReuseEvaluation canReuseCodec(MediaCodecInfo codecInfo, Format oldFormat, Format newFormat) {
        DecoderReuseEvaluation evaluation = codecInfo.canReuseCodec(oldFormat, newFormat);
        int discardReasons = evaluation.discardReasons;
        if (newFormat.width > this.codecMaxValues.width || newFormat.height > this.codecMaxValues.height) {
            discardReasons |= 0x100;
        }
        if (MediaCodecVideoRenderer.getMaxInputSize(codecInfo, newFormat) > this.codecMaxValues.inputSize) {
            discardReasons |= 0x40;
        }
        return new DecoderReuseEvaluation(codecInfo.name, oldFormat, newFormat, discardReasons != 0 ? 0 : evaluation.result, discardReasons);
    }

    @Override
    @CallSuper
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        super.render(positionUs, elapsedRealtimeUs);
        if (this.videoFrameProcessorManager.isEnabled()) {
            this.videoFrameProcessorManager.releaseProcessedFrames(positionUs, elapsedRealtimeUs);
        }
    }

    @Override
    @CallSuper
    protected void resetCodecStateForFlush() {
        super.resetCodecStateForFlush();
        this.buffersInCodecCount = 0;
    }

    @Override
    public void setPlaybackSpeed(float currentPlaybackSpeed, float targetPlaybackSpeed) throws ExoPlaybackException {
        super.setPlaybackSpeed(currentPlaybackSpeed, targetPlaybackSpeed);
        this.frameReleaseHelper.onPlaybackSpeed(currentPlaybackSpeed);
    }

    public static int getCodecMaxInputSize(MediaCodecInfo codecInfo, Format format) {
        int width = format.width;
        int height = format.height;
        if (width == -1 || height == -1) {
            return -1;
        }
        String sampleMimeType = format.sampleMimeType;
        if ("video/dolby-vision".equals(sampleMimeType)) {
            int profile;
            sampleMimeType = "video/hevc";
            Pair<Integer, Integer> codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel(format);
            if (codecProfileAndLevel != null && ((profile = ((Integer)codecProfileAndLevel.first).intValue()) == 512 || profile == 1 || profile == 2)) {
                sampleMimeType = "video/avc";
            }
        }
        switch (sampleMimeType) {
            case "video/3gpp": 
            case "video/mp4v-es": 
            case "video/av01": 
            case "video/x-vnd.on2.vp8": {
                return MediaCodecVideoRenderer.getMaxSampleSize(width * height, 2);
            }
            case "video/hevc": {
                return Math.max(0x200000, MediaCodecVideoRenderer.getMaxSampleSize(width * height, 2));
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(Util.MODEL) || "Amazon".equals(Util.MANUFACTURER) && ("KFSOWI".equals(Util.MODEL) || "AFTS".equals(Util.MODEL) && codecInfo.secure)) {
                    return -1;
                }
                int maxPixels = Util.ceilDivide((int)width, (int)16) * Util.ceilDivide((int)height, (int)16) * 16 * 16;
                return MediaCodecVideoRenderer.getMaxSampleSize(maxPixels, 2);
            }
            case "video/x-vnd.on2.vp9": {
                return MediaCodecVideoRenderer.getMaxSampleSize(width * height, 4);
            }
        }
        return -1;
    }

    @Override
    protected float getCodecOperatingRateV23(float targetPlaybackSpeed, Format format, Format[] streamFormats) {
        float maxFrameRate = -1.0f;
        for (Format streamFormat : streamFormats) {
            float streamFrameRate = streamFormat.frameRate;
            if (streamFrameRate == -1.0f) continue;
            maxFrameRate = Math.max(maxFrameRate, streamFrameRate);
        }
        return maxFrameRate == -1.0f ? -1.0f : maxFrameRate * targetPlaybackSpeed;
    }

    @Override
    @CallSuper
    protected void onReadyToInitializeCodec(Format format) throws ExoPlaybackException {
        if (!this.videoFrameProcessorManager.isEnabled()) {
            this.videoFrameProcessorManager.maybeEnable(format, this.getOutputStreamOffsetUs());
        }
    }

    @Override
    protected void onCodecInitialized(String name, MediaCodecAdapter.Configuration configuration, long initializedTimestampMs, long initializationDurationMs) {
        this.eventDispatcher.decoderInitialized(name, initializedTimestampMs, initializationDurationMs);
        this.codecNeedsSetOutputSurfaceWorkaround = this.codecNeedsSetOutputSurfaceWorkaround(name);
        this.codecHandlesHdr10PlusOutOfBandMetadata = ((MediaCodecInfo)Assertions.checkNotNull((Object)this.getCodecInfo())).isHdr10PlusOutOfBandMetadataSupported();
        if (Util.SDK_INT >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new OnFrameRenderedListenerV23((MediaCodecAdapter)Assertions.checkNotNull((Object)this.getCodec()));
        }
        this.videoFrameProcessorManager.onCodecInitialized(name);
    }

    @Override
    protected void onCodecReleased(String name) {
        this.eventDispatcher.decoderReleased(name);
    }

    @Override
    protected void onCodecError(Exception codecError) {
        Log.e((String)TAG, (String)"Video codec error", (Throwable)codecError);
        this.eventDispatcher.videoCodecError(codecError);
    }

    @Override
    @Nullable
    protected DecoderReuseEvaluation onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        DecoderReuseEvaluation evaluation = super.onInputFormatChanged(formatHolder);
        this.eventDispatcher.inputFormatChanged(formatHolder.format, evaluation);
        return evaluation;
    }

    @Override
    @CallSuper
    protected void onQueueInputBuffer(DecoderInputBuffer buffer) throws ExoPlaybackException {
        if (!this.tunneling) {
            ++this.buffersInCodecCount;
        }
        if (Util.SDK_INT < 23 && this.tunneling) {
            this.onProcessedTunneledBuffer(buffer.timeUs);
        }
    }

    @Override
    protected void onOutputFormatChanged(Format format, @Nullable MediaFormat mediaFormat) {
        int height;
        int width;
        MediaCodecAdapter codec = this.getCodec();
        if (codec != null) {
            codec.setVideoScalingMode(this.scalingMode);
        }
        int unappliedRotationDegrees = 0;
        if (this.tunneling) {
            width = format.width;
            height = format.height;
        } else {
            Assertions.checkNotNull((Object)mediaFormat);
            boolean hasCrop = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
            width = hasCrop ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
            height = hasCrop ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        }
        float pixelWidthHeightRatio = format.pixelWidthHeightRatio;
        if (MediaCodecVideoRenderer.codecAppliesRotation()) {
            if (format.rotationDegrees == 90 || format.rotationDegrees == 270) {
                int rotatedHeight = width;
                width = height;
                height = rotatedHeight;
                pixelWidthHeightRatio = 1.0f / pixelWidthHeightRatio;
            }
        } else if (!this.videoFrameProcessorManager.isEnabled()) {
            unappliedRotationDegrees = format.rotationDegrees;
        }
        this.decodedVideoSize = new VideoSize(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
        this.frameReleaseHelper.onFormatChanged(format.frameRate);
        if (this.videoFrameProcessorManager.isEnabled()) {
            this.videoFrameProcessorManager.setInputFormat(format.buildUpon().setWidth(width).setHeight(height).setRotationDegrees(unappliedRotationDegrees).setPixelWidthHeightRatio(pixelWidthHeightRatio).build());
        }
    }

    @Override
    @TargetApi(value=29)
    protected void handleInputBufferSupplementalData(DecoderInputBuffer buffer) throws ExoPlaybackException {
        if (!this.codecHandlesHdr10PlusOutOfBandMetadata) {
            return;
        }
        ByteBuffer data = (ByteBuffer)Assertions.checkNotNull((Object)buffer.supplementalData);
        if (data.remaining() >= 7) {
            byte ituTT35CountryCode = data.get();
            short ituTT35TerminalProviderCode = data.getShort();
            short ituTT35TerminalProviderOrientedCode = data.getShort();
            byte applicationIdentifier = data.get();
            byte applicationVersion = data.get();
            data.position(0);
            if (ituTT35CountryCode == -75 && ituTT35TerminalProviderCode == 60 && ituTT35TerminalProviderOrientedCode == 1 && applicationIdentifier == 4 && (applicationVersion == 0 || applicationVersion == 1)) {
                byte[] hdr10PlusInfo = new byte[data.remaining()];
                data.get(hdr10PlusInfo);
                data.position(0);
                MediaCodecVideoRenderer.setHdr10PlusInfoV29(this.getCodec(), hdr10PlusInfo);
            }
        }
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, @Nullable MediaCodecAdapter codec, @Nullable ByteBuffer buffer, int bufferIndex, int bufferFlags, int sampleCount, long bufferPresentationTimeUs, boolean isDecodeOnlyBuffer, boolean isLastBuffer, Format format) throws ExoPlaybackException {
        boolean treatDroppedBuffersAsSkipped;
        Assertions.checkNotNull((Object)codec);
        if (this.initialPositionUs == -9223372036854775807L) {
            this.initialPositionUs = positionUs;
        }
        if (bufferPresentationTimeUs != this.lastBufferPresentationTimeUs) {
            if (!this.videoFrameProcessorManager.isEnabled()) {
                this.frameReleaseHelper.onNextFrame(bufferPresentationTimeUs);
            }
            this.lastBufferPresentationTimeUs = bufferPresentationTimeUs;
        }
        long outputStreamOffsetUs = this.getOutputStreamOffsetUs();
        long presentationTimeUs = bufferPresentationTimeUs - outputStreamOffsetUs;
        if (isDecodeOnlyBuffer && !isLastBuffer) {
            this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
            return true;
        }
        boolean isStarted = this.getState() == 2;
        long elapsedRealtimeNowUs = SystemClock.elapsedRealtime() * 1000L;
        long earlyUs = this.calculateEarlyTimeUs(positionUs, elapsedRealtimeUs, elapsedRealtimeNowUs, bufferPresentationTimeUs, isStarted);
        if (this.displaySurface == this.placeholderSurface) {
            if (MediaCodecVideoRenderer.isBufferLate(earlyUs)) {
                this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
                this.updateVideoFrameProcessingOffsetCounters(earlyUs);
                return true;
            }
            return false;
        }
        boolean forceRenderOutputBuffer = this.shouldForceRender(positionUs, earlyUs);
        if (forceRenderOutputBuffer) {
            boolean notifyFrameMetaDataListener;
            if (this.videoFrameProcessorManager.isEnabled()) {
                notifyFrameMetaDataListener = false;
                if (!this.videoFrameProcessorManager.maybeRegisterFrame(format, presentationTimeUs, isLastBuffer)) {
                    return false;
                }
            } else {
                notifyFrameMetaDataListener = true;
            }
            this.renderOutputBufferNow(codec, format, bufferIndex, presentationTimeUs, notifyFrameMetaDataListener);
            this.updateVideoFrameProcessingOffsetCounters(earlyUs);
            return true;
        }
        if (!isStarted || positionUs == this.initialPositionUs) {
            return false;
        }
        long systemTimeNs = System.nanoTime();
        long unadjustedFrameReleaseTimeNs = systemTimeNs + earlyUs * 1000L;
        long adjustedReleaseTimeNs = this.frameReleaseHelper.adjustReleaseTime(unadjustedFrameReleaseTimeNs);
        if (!this.videoFrameProcessorManager.isEnabled()) {
            earlyUs = (adjustedReleaseTimeNs - systemTimeNs) / 1000L;
        }
        boolean bl = treatDroppedBuffersAsSkipped = this.joiningDeadlineMs != -9223372036854775807L;
        if (this.shouldDropBuffersToKeyframe(earlyUs, elapsedRealtimeUs, isLastBuffer) && this.maybeDropBuffersToKeyframe(positionUs, treatDroppedBuffersAsSkipped)) {
            return false;
        }
        if (this.shouldDropOutputBuffer(earlyUs, elapsedRealtimeUs, isLastBuffer)) {
            if (treatDroppedBuffersAsSkipped) {
                this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
            } else {
                this.dropOutputBuffer(codec, bufferIndex, presentationTimeUs);
            }
            this.updateVideoFrameProcessingOffsetCounters(earlyUs);
            return true;
        }
        if (this.videoFrameProcessorManager.isEnabled()) {
            this.videoFrameProcessorManager.releaseProcessedFrames(positionUs, elapsedRealtimeUs);
            if (this.videoFrameProcessorManager.maybeRegisterFrame(format, presentationTimeUs, isLastBuffer)) {
                this.renderOutputBufferNow(codec, format, bufferIndex, presentationTimeUs, false);
                return true;
            }
            return false;
        }
        if (Util.SDK_INT >= 21) {
            if (earlyUs < 50000L) {
                if (adjustedReleaseTimeNs == this.lastFrameReleaseTimeNs) {
                    this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
                } else {
                    this.notifyFrameMetadataListener(presentationTimeUs, adjustedReleaseTimeNs, format);
                    this.renderOutputBufferV21(codec, bufferIndex, presentationTimeUs, adjustedReleaseTimeNs);
                }
                this.updateVideoFrameProcessingOffsetCounters(earlyUs);
                this.lastFrameReleaseTimeNs = adjustedReleaseTimeNs;
                return true;
            }
        } else if (earlyUs < 30000L) {
            if (earlyUs > 11000L) {
                try {
                    Thread.sleep((earlyUs - 10000L) / 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            this.notifyFrameMetadataListener(presentationTimeUs, adjustedReleaseTimeNs, format);
            this.renderOutputBuffer(codec, bufferIndex, presentationTimeUs);
            this.updateVideoFrameProcessingOffsetCounters(earlyUs);
            return true;
        }
        return false;
    }

    private boolean shouldForceRender(long positionUs, long earlyUs) {
        boolean isStarted;
        boolean bl = isStarted = this.getState() == 2;
        boolean shouldRenderFirstFrame = !this.renderedFirstFrameAfterEnable ? isStarted || this.mayRenderFirstFrameAfterEnableIfNotStarted : !this.renderedFirstFrameAfterReset;
        long elapsedSinceLastRenderUs = SystemClock.elapsedRealtime() * 1000L - this.lastRenderRealtimeUs;
        return this.joiningDeadlineMs == -9223372036854775807L && positionUs >= this.getOutputStreamOffsetUs() && (shouldRenderFirstFrame || isStarted && this.shouldForceRenderOutputBuffer(earlyUs, elapsedSinceLastRenderUs));
    }

    private long calculateEarlyTimeUs(long positionUs, long elapsedRealtimeUs, long elapsedRealtimeNowUs, long bufferPresentationTimeUs, boolean isStarted) {
        double playbackSpeed = this.getPlaybackSpeed();
        long earlyUs = (long)((double)(bufferPresentationTimeUs - positionUs) / playbackSpeed);
        if (isStarted) {
            earlyUs -= elapsedRealtimeNowUs - elapsedRealtimeUs;
        }
        return earlyUs;
    }

    private void notifyFrameMetadataListener(long presentationTimeUs, long releaseTimeNs, Format format) {
        if (this.frameMetadataListener != null) {
            this.frameMetadataListener.onVideoFrameAboutToBeRendered(presentationTimeUs, releaseTimeNs, format, this.getCodecOutputMediaFormat());
        }
    }

    protected void onProcessedTunneledBuffer(long presentationTimeUs) throws ExoPlaybackException {
        this.updateOutputFormatForTime(presentationTimeUs);
        this.maybeNotifyVideoSizeChanged(this.decodedVideoSize);
        ++this.decoderCounters.renderedOutputBufferCount;
        this.maybeNotifyRenderedFirstFrame();
        this.onProcessedOutputBuffer(presentationTimeUs);
    }

    private void onProcessedTunneledEndOfStream() {
        this.setPendingOutputEndOfStream();
    }

    @Override
    @CallSuper
    protected void onProcessedOutputBuffer(long presentationTimeUs) {
        super.onProcessedOutputBuffer(presentationTimeUs);
        if (!this.tunneling) {
            --this.buffersInCodecCount;
        }
    }

    @Override
    protected void onProcessedStreamChange() {
        super.onProcessedStreamChange();
        this.clearRenderedFirstFrame();
    }

    protected boolean shouldDropOutputBuffer(long earlyUs, long elapsedRealtimeUs, boolean isLastBuffer) {
        return MediaCodecVideoRenderer.isBufferLate(earlyUs) && !isLastBuffer;
    }

    protected boolean shouldDropBuffersToKeyframe(long earlyUs, long elapsedRealtimeUs, boolean isLastBuffer) {
        return MediaCodecVideoRenderer.isBufferVeryLate(earlyUs) && !isLastBuffer;
    }

    protected boolean shouldForceRenderOutputBuffer(long earlyUs, long elapsedSinceLastRenderUs) {
        return MediaCodecVideoRenderer.isBufferLate(earlyUs) && elapsedSinceLastRenderUs > 100000L;
    }

    protected void skipOutputBuffer(MediaCodecAdapter codec, int index, long presentationTimeUs) {
        TraceUtil.beginSection((String)"skipVideoBuffer");
        codec.releaseOutputBuffer(index, false);
        TraceUtil.endSection();
        ++this.decoderCounters.skippedOutputBufferCount;
    }

    protected void dropOutputBuffer(MediaCodecAdapter codec, int index, long presentationTimeUs) {
        TraceUtil.beginSection((String)"dropVideoBuffer");
        codec.releaseOutputBuffer(index, false);
        TraceUtil.endSection();
        this.updateDroppedBufferCounters(0, 1);
    }

    protected boolean maybeDropBuffersToKeyframe(long positionUs, boolean treatDroppedBuffersAsSkipped) throws ExoPlaybackException {
        int droppedSourceBufferCount = this.skipSource(positionUs);
        if (droppedSourceBufferCount == 0) {
            return false;
        }
        if (treatDroppedBuffersAsSkipped) {
            this.decoderCounters.skippedInputBufferCount += droppedSourceBufferCount;
            this.decoderCounters.skippedOutputBufferCount += this.buffersInCodecCount;
        } else {
            ++this.decoderCounters.droppedToKeyframeCount;
            this.updateDroppedBufferCounters(droppedSourceBufferCount, this.buffersInCodecCount);
        }
        this.flushOrReinitializeCodec();
        if (this.videoFrameProcessorManager.isEnabled()) {
            this.videoFrameProcessorManager.flush();
        }
        return true;
    }

    protected void updateDroppedBufferCounters(int droppedInputBufferCount, int droppedDecoderBufferCount) {
        this.decoderCounters.droppedInputBufferCount += droppedInputBufferCount;
        int totalDroppedBufferCount = droppedInputBufferCount + droppedDecoderBufferCount;
        this.decoderCounters.droppedBufferCount += totalDroppedBufferCount;
        this.droppedFrames += totalDroppedBufferCount;
        this.consecutiveDroppedFrameCount += totalDroppedBufferCount;
        this.decoderCounters.maxConsecutiveDroppedBufferCount = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.maxConsecutiveDroppedBufferCount);
        if (this.maxDroppedFramesToNotify > 0 && this.droppedFrames >= this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected void updateVideoFrameProcessingOffsetCounters(long processingOffsetUs) {
        this.decoderCounters.addVideoFrameProcessingOffset(processingOffsetUs);
        this.totalVideoFrameProcessingOffsetUs += processingOffsetUs;
        ++this.videoFrameProcessingOffsetCount;
    }

    protected Pair<ColorInfo, ColorInfo> experimentalGetVideoFrameProcessorColorConfiguration(@Nullable ColorInfo inputColorInfo) {
        if (!ColorInfo.isTransferHdr((ColorInfo)inputColorInfo)) {
            return Pair.create((Object)ColorInfo.SDR_BT709_LIMITED, (Object)ColorInfo.SDR_BT709_LIMITED);
        }
        if (inputColorInfo.colorTransfer == 7) {
            return Pair.create((Object)inputColorInfo, (Object)inputColorInfo.buildUpon().setColorTransfer(6).build());
        }
        return Pair.create((Object)inputColorInfo, (Object)inputColorInfo);
    }

    private void renderOutputBufferNow(MediaCodecAdapter codec, Format format, int index, long presentationTimeUs, boolean notifyFrameMetadataListener) {
        long releaseTimeNs;
        long l = releaseTimeNs = this.videoFrameProcessorManager.isEnabled() ? this.videoFrameProcessorManager.getCorrectedFramePresentationTimeUs(presentationTimeUs, this.getOutputStreamOffsetUs()) * 1000L : System.nanoTime();
        if (notifyFrameMetadataListener) {
            this.notifyFrameMetadataListener(presentationTimeUs, releaseTimeNs, format);
        }
        if (Util.SDK_INT >= 21) {
            this.renderOutputBufferV21(codec, index, presentationTimeUs, releaseTimeNs);
        } else {
            this.renderOutputBuffer(codec, index, presentationTimeUs);
        }
    }

    protected void renderOutputBuffer(MediaCodecAdapter codec, int index, long presentationTimeUs) {
        TraceUtil.beginSection((String)"releaseOutputBuffer");
        codec.releaseOutputBuffer(index, true);
        TraceUtil.endSection();
        ++this.decoderCounters.renderedOutputBufferCount;
        this.consecutiveDroppedFrameCount = 0;
        if (!this.videoFrameProcessorManager.isEnabled()) {
            this.lastRenderRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
            this.maybeNotifyVideoSizeChanged(this.decodedVideoSize);
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @RequiresApi(value=21)
    protected void renderOutputBufferV21(MediaCodecAdapter codec, int index, long presentationTimeUs, long releaseTimeNs) {
        TraceUtil.beginSection((String)"releaseOutputBuffer");
        codec.releaseOutputBuffer(index, releaseTimeNs);
        TraceUtil.endSection();
        ++this.decoderCounters.renderedOutputBufferCount;
        this.consecutiveDroppedFrameCount = 0;
        if (!this.videoFrameProcessorManager.isEnabled()) {
            this.lastRenderRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
            this.maybeNotifyVideoSizeChanged(this.decodedVideoSize);
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    private boolean shouldUsePlaceholderSurface(MediaCodecInfo codecInfo) {
        return Util.SDK_INT >= 23 && !this.tunneling && !this.codecNeedsSetOutputSurfaceWorkaround(codecInfo.name) && (!codecInfo.secure || PlaceholderSurface.isSecureSupported(this.context));
    }

    @RequiresApi(value=17)
    private void releasePlaceholderSurface() {
        if (this.displaySurface == this.placeholderSurface) {
            this.displaySurface = null;
        }
        this.placeholderSurface.release();
        this.placeholderSurface = null;
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void clearRenderedFirstFrame() {
        MediaCodecAdapter codec;
        this.renderedFirstFrameAfterReset = false;
        if (Util.SDK_INT >= 23 && this.tunneling && (codec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new OnFrameRenderedListenerV23(codec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        this.renderedFirstFrameAfterEnable = true;
        if (!this.renderedFirstFrameAfterReset) {
            this.renderedFirstFrameAfterReset = true;
            this.eventDispatcher.renderedFirstFrame(this.displaySurface);
            this.haveReportedFirstFrameRenderedForCurrentSurface = true;
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.haveReportedFirstFrameRenderedForCurrentSurface) {
            this.eventDispatcher.renderedFirstFrame(this.displaySurface);
        }
    }

    private void clearReportedVideoSize() {
        this.reportedVideoSize = null;
    }

    private void maybeNotifyVideoSizeChanged(VideoSize newOutputSize) {
        if (!newOutputSize.equals((Object)VideoSize.UNKNOWN) && !newOutputSize.equals((Object)this.reportedVideoSize)) {
            this.reportedVideoSize = newOutputSize;
            this.eventDispatcher.videoSizeChanged(this.reportedVideoSize);
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedVideoSize != null) {
            this.eventDispatcher.videoSizeChanged(this.reportedVideoSize);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long now = SystemClock.elapsedRealtime();
            long elapsedMs = now - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.droppedFrames(this.droppedFrames, elapsedMs);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = now;
        }
    }

    private void maybeNotifyVideoFrameProcessingOffset() {
        if (this.videoFrameProcessingOffsetCount != 0) {
            this.eventDispatcher.reportVideoFrameProcessingOffset(this.totalVideoFrameProcessingOffsetUs, this.videoFrameProcessingOffsetCount);
            this.totalVideoFrameProcessingOffsetUs = 0L;
            this.videoFrameProcessingOffsetCount = 0;
        }
    }

    private static boolean isBufferLate(long earlyUs) {
        return earlyUs < -30000L;
    }

    private static boolean isBufferVeryLate(long earlyUs) {
        return earlyUs < -500000L;
    }

    @RequiresApi(value=29)
    private static void setHdr10PlusInfoV29(MediaCodecAdapter codec, byte[] hdr10PlusInfo) {
        Bundle codecParameters = new Bundle();
        codecParameters.putByteArray("hdr10-plus-info", hdr10PlusInfo);
        codec.setParameters(codecParameters);
    }

    @RequiresApi(value=23)
    protected void setOutputSurfaceV23(MediaCodecAdapter codec, Surface surface) {
        codec.setOutputSurface(surface);
    }

    @RequiresApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int tunnelingAudioSessionId) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", tunnelingAudioSessionId);
    }

    @SuppressLint(value={"InlinedApi"})
    @TargetApi(value=21)
    protected MediaFormat getMediaFormat(Format format, String codecMimeType, CodecMaxValues codecMaxValues, float codecOperatingRate, boolean deviceNeedsNoPostProcessWorkaround, int tunnelingAudioSessionId) {
        Pair<Integer, Integer> codecProfileAndLevel;
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", codecMimeType);
        mediaFormat.setInteger("width", format.width);
        mediaFormat.setInteger("height", format.height);
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        MediaFormatUtil.maybeSetFloat((MediaFormat)mediaFormat, (String)"frame-rate", (float)format.frameRate);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"rotation-degrees", (int)format.rotationDegrees);
        MediaFormatUtil.maybeSetColorInfo((MediaFormat)mediaFormat, (ColorInfo)format.colorInfo);
        if ("video/dolby-vision".equals(format.sampleMimeType) && (codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel(format)) != null) {
            MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"profile", (int)((Integer)codecProfileAndLevel.first));
        }
        mediaFormat.setInteger("max-width", codecMaxValues.width);
        mediaFormat.setInteger("max-height", codecMaxValues.height);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)codecMaxValues.inputSize);
        if (Util.SDK_INT >= 23) {
            mediaFormat.setInteger("priority", 0);
            if (codecOperatingRate != -1.0f) {
                mediaFormat.setFloat("operating-rate", codecOperatingRate);
            }
        }
        if (deviceNeedsNoPostProcessWorkaround) {
            mediaFormat.setInteger("no-post-process", 1);
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (tunnelingAudioSessionId != 0) {
            MediaCodecVideoRenderer.configureTunnelingV21(mediaFormat, tunnelingAudioSessionId);
        }
        return mediaFormat;
    }

    protected CodecMaxValues getCodecMaxValues(MediaCodecInfo codecInfo, Format format, Format[] streamFormats) {
        int maxWidth = format.width;
        int maxHeight = format.height;
        int maxInputSize = MediaCodecVideoRenderer.getMaxInputSize(codecInfo, format);
        if (streamFormats.length == 1) {
            int codecMaxInputSize;
            if (maxInputSize != -1 && (codecMaxInputSize = MediaCodecVideoRenderer.getCodecMaxInputSize(codecInfo, format)) != -1) {
                int scaledMaxInputSize = (int)((float)maxInputSize * 1.5f);
                maxInputSize = Math.min(scaledMaxInputSize, codecMaxInputSize);
            }
            return new CodecMaxValues(maxWidth, maxHeight, maxInputSize);
        }
        boolean haveUnknownDimensions = false;
        for (Format streamFormat : streamFormats) {
            if (format.colorInfo != null && streamFormat.colorInfo == null) {
                streamFormat = streamFormat.buildUpon().setColorInfo(format.colorInfo).build();
            }
            if (codecInfo.canReuseCodec((Format)format, (Format)streamFormat).result == 0) continue;
            haveUnknownDimensions |= streamFormat.width == -1 || streamFormat.height == -1;
            maxWidth = Math.max(maxWidth, streamFormat.width);
            maxHeight = Math.max(maxHeight, streamFormat.height);
            maxInputSize = Math.max(maxInputSize, MediaCodecVideoRenderer.getMaxInputSize(codecInfo, streamFormat));
        }
        if (haveUnknownDimensions) {
            Log.w((String)TAG, (String)("Resolutions unknown. Codec max resolution: " + maxWidth + "x" + maxHeight));
            Point codecMaxSize = MediaCodecVideoRenderer.getCodecMaxSize(codecInfo, format);
            if (codecMaxSize != null) {
                maxWidth = Math.max(maxWidth, codecMaxSize.x);
                maxHeight = Math.max(maxHeight, codecMaxSize.y);
                maxInputSize = Math.max(maxInputSize, MediaCodecVideoRenderer.getCodecMaxInputSize(codecInfo, format.buildUpon().setWidth(maxWidth).setHeight(maxHeight).build()));
                Log.w((String)TAG, (String)("Codec max resolution adjusted to: " + maxWidth + "x" + maxHeight));
            }
        }
        return new CodecMaxValues(maxWidth, maxHeight, maxInputSize);
    }

    @Override
    protected MediaCodecDecoderException createDecoderException(Throwable cause, @Nullable MediaCodecInfo codecInfo) {
        return new MediaCodecVideoDecoderException(cause, codecInfo, this.displaySurface);
    }

    @Nullable
    private static Point getCodecMaxSize(MediaCodecInfo codecInfo, Format format) {
        boolean isVerticalVideo = format.height > format.width;
        int formatLongEdgePx = isVerticalVideo ? format.height : format.width;
        int formatShortEdgePx = isVerticalVideo ? format.width : format.height;
        float aspectRatio = (float)formatShortEdgePx / (float)formatLongEdgePx;
        for (int longEdgePx : STANDARD_LONG_EDGE_VIDEO_PX) {
            int shortEdgePx = (int)((float)longEdgePx * aspectRatio);
            if (longEdgePx <= formatLongEdgePx || shortEdgePx <= formatShortEdgePx) {
                return null;
            }
            if (Util.SDK_INT >= 21) {
                Point alignedSize = codecInfo.alignVideoSizeV21(isVerticalVideo ? shortEdgePx : longEdgePx, isVerticalVideo ? longEdgePx : shortEdgePx);
                float frameRate = format.frameRate;
                if (!codecInfo.isVideoSizeAndRateSupportedV21(alignedSize.x, alignedSize.y, frameRate)) continue;
                return alignedSize;
            }
            try {
                longEdgePx = Util.ceilDivide((int)longEdgePx, (int)16) * 16;
                shortEdgePx = Util.ceilDivide((int)shortEdgePx, (int)16) * 16;
                if (longEdgePx * shortEdgePx > MediaCodecUtil.maxH264DecodableFrameSize()) continue;
                return new Point(isVerticalVideo ? shortEdgePx : longEdgePx, isVerticalVideo ? longEdgePx : shortEdgePx);
            }
            catch (MediaCodecUtil.DecoderQueryException e) {
                return null;
            }
        }
        return null;
    }

    protected static int getMaxInputSize(MediaCodecInfo codecInfo, Format format) {
        if (format.maxInputSize != -1) {
            int totalInitializationDataSize = 0;
            int initializationDataCount = format.initializationData.size();
            for (int i = 0; i < initializationDataCount; ++i) {
                totalInitializationDataSize += ((byte[])format.initializationData.get(i)).length;
            }
            return format.maxInputSize + totalInitializationDataSize;
        }
        return MediaCodecVideoRenderer.getCodecMaxInputSize(codecInfo, format);
    }

    private static boolean codecAppliesRotation() {
        return Util.SDK_INT >= 21;
    }

    private static boolean deviceNeedsNoPostProcessWorkaround() {
        return "NVIDIA".equals(Util.MANUFACTURER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean codecNeedsSetOutputSurfaceWorkaround(String name) {
        if (name.startsWith("OMX.google")) {
            return false;
        }
        Class<MediaCodecVideoRenderer> clazz = MediaCodecVideoRenderer.class;
        synchronized (MediaCodecVideoRenderer.class) {
            if (!evaluatedDeviceNeedsSetOutputSurfaceWorkaround) {
                deviceNeedsSetOutputSurfaceWorkaround = MediaCodecVideoRenderer.evaluateDeviceNeedsSetOutputSurfaceWorkaround();
                evaluatedDeviceNeedsSetOutputSurfaceWorkaround = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return deviceNeedsSetOutputSurfaceWorkaround;
        }
    }

    @Nullable
    protected Surface getSurface() {
        return this.displaySurface;
    }

    private static int getMaxSampleSize(int pixelCount, int minCompressionRatio) {
        return pixelCount * 3 / (2 * minCompressionRatio);
    }

    private static boolean evaluateDeviceNeedsSetOutputSurfaceWorkaround() {
        if (Util.SDK_INT <= 28) {
            switch (Util.DEVICE) {
                case "aquaman": 
                case "dangal": 
                case "dangalUHD": 
                case "dangalFHD": 
                case "magnolia": 
                case "machuca": 
                case "once": 
                case "oneday": {
                    return true;
                }
            }
        }
        if (Util.SDK_INT <= 27 && "HWEML".equals(Util.DEVICE)) {
            return true;
        }
        switch (Util.MODEL) {
            case "AFTA": 
            case "AFTN": 
            case "AFTR": 
            case "AFTEU011": 
            case "AFTEU014": 
            case "AFTEUFF014": 
            case "AFTJMST12": 
            case "AFTKMST12": 
            case "AFTSO001": {
                return true;
            }
        }
        if (Util.SDK_INT <= 26) {
            switch (Util.DEVICE) {
                case "1601": 
                case "1713": 
                case "1714": 
                case "601LV": 
                case "602LV": 
                case "A10-70F": 
                case "A10-70L": 
                case "A1601": 
                case "A2016a40": 
                case "A7000-a": 
                case "A7000plus": 
                case "A7010a48": 
                case "A7020a48": 
                case "AquaPowerM": 
                case "ASUS_X00AD_2": 
                case "Aura_Note_2": 
                case "b5": 
                case "BLACK-1X": 
                case "BRAVIA_ATV2": 
                case "BRAVIA_ATV3_4K": 
                case "C1": 
                case "ComioS1": 
                case "CP8676_I02": 
                case "CPH1609": 
                case "CPH1715": 
                case "CPY83_I00": 
                case "cv1": 
                case "cv3": 
                case "deb": 
                case "DM-01K": 
                case "E5643": 
                case "ELUGA_A3_Pro": 
                case "ELUGA_Note": 
                case "ELUGA_Prim": 
                case "ELUGA_Ray_X": 
                case "EverStar_S": 
                case "F01H": 
                case "F01J": 
                case "F02H": 
                case "F03H": 
                case "F04H": 
                case "F04J": 
                case "F3111": 
                case "F3113": 
                case "F3116": 
                case "F3211": 
                case "F3213": 
                case "F3215": 
                case "F3311": 
                case "flo": 
                case "fugu": 
                case "GiONEE_CBL7513": 
                case "GiONEE_GBL7319": 
                case "GIONEE_GBL7360": 
                case "GIONEE_SWW1609": 
                case "GIONEE_SWW1627": 
                case "GIONEE_SWW1631": 
                case "GIONEE_WBL5708": 
                case "GIONEE_WBL7365": 
                case "GIONEE_WBL7519": 
                case "griffin": 
                case "htc_e56ml_dtul": 
                case "hwALE-H": 
                case "HWBLN-H": 
                case "HWCAM-H": 
                case "HWVNS-H": 
                case "HWWAS-H": 
                case "i9031": 
                case "iball8735_9806": 
                case "Infinix-X572": 
                case "iris60": 
                case "itel_S41": 
                case "j2xlteins": 
                case "JGZ": 
                case "K50a40": 
                case "kate": 
                case "l5460": 
                case "le_x6": 
                case "LS-5017": 
                case "M04": 
                case "M5c": 
                case "manning": 
                case "marino_f": 
                case "MEIZU_M5": 
                case "mh": 
                case "mido": 
                case "MX6": 
                case "namath": 
                case "nicklaus_f": 
                case "NX541J": 
                case "NX573J": 
                case "OnePlus5T": 
                case "p212": 
                case "P681": 
                case "P85": 
                case "pacificrim": 
                case "panell_d": 
                case "panell_dl": 
                case "panell_ds": 
                case "panell_dt": 
                case "PB2-670M": 
                case "PGN528": 
                case "PGN610": 
                case "PGN611": 
                case "Phantom6": 
                case "Pixi4-7_3G": 
                case "Pixi5-10_4G": 
                case "PLE": 
                case "PRO7S": 
                case "Q350": 
                case "Q4260": 
                case "Q427": 
                case "Q4310": 
                case "Q5": 
                case "QM16XE_U": 
                case "QX1": 
                case "RAIJIN": 
                case "santoni": 
                case "Slate_Pro": 
                case "SVP-DTV15": 
                case "s905x018": 
                case "taido_row": 
                case "TB3-730F": 
                case "TB3-730X": 
                case "TB3-850F": 
                case "TB3-850M": 
                case "tcl_eu": 
                case "V1": 
                case "V23GB": 
                case "V5": 
                case "vernee_M5": 
                case "watson": 
                case "whyred": 
                case "woods_f": 
                case "woods_fn": 
                case "X3_HK": 
                case "XE2X": 
                case "XT1663": 
                case "Z12_PRO": 
                case "Z80": {
                    return true;
                }
            }
            switch (Util.MODEL) {
                case "JSN-L21": {
                    return true;
                }
            }
        }
        return false;
    }

    @RequiresApi(value=23)
    private final class OnFrameRenderedListenerV23
    implements MediaCodecAdapter.OnFrameRenderedListener,
    Handler.Callback {
        private static final int HANDLE_FRAME_RENDERED = 0;
        private final Handler handler = Util.createHandlerForCurrentLooper((Handler.Callback)this);

        public OnFrameRenderedListenerV23(MediaCodecAdapter codec) {
            codec.setOnFrameRenderedListener(this, this.handler);
        }

        @Override
        public void onFrameRendered(MediaCodecAdapter codec, long presentationTimeUs, long nanoTime) {
            if (Util.SDK_INT < 30) {
                Message message = Message.obtain((Handler)this.handler, (int)0, (int)((int)(presentationTimeUs >> 32)), (int)((int)presentationTimeUs));
                this.handler.sendMessageAtFrontOfQueue(message);
            } else {
                this.handleFrameRendered(presentationTimeUs);
            }
        }

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    this.handleFrameRendered(Util.toLong((int)message.arg1, (int)message.arg2));
                    return true;
                }
            }
            return false;
        }

        private void handleFrameRendered(long presentationTimeUs) {
            if (this != MediaCodecVideoRenderer.this.tunnelingOnFrameRenderedListener || MediaCodecVideoRenderer.this.getCodec() == null) {
                return;
            }
            if (presentationTimeUs == Long.MAX_VALUE) {
                MediaCodecVideoRenderer.this.onProcessedTunneledEndOfStream();
            } else {
                try {
                    MediaCodecVideoRenderer.this.onProcessedTunneledBuffer(presentationTimeUs);
                }
                catch (ExoPlaybackException e) {
                    MediaCodecVideoRenderer.this.setPendingPlaybackException(e);
                }
            }
        }
    }

    protected static final class CodecMaxValues {
        public final int width;
        public final int height;
        public final int inputSize;

        public CodecMaxValues(int width, int height, int inputSize) {
            this.width = width;
            this.height = height;
            this.inputSize = inputSize;
        }
    }

    private static final class VideoFrameProcessorManager {
        private static final long EARLY_THRESHOLD_US = 50000L;
        private final VideoFrameReleaseHelper frameReleaseHelper;
        private final MediaCodecVideoRenderer renderer;
        private final ArrayDeque<Long> processedFramesTimestampsUs;
        private final ArrayDeque<Pair<Long, Format>> pendingFrameFormats;
        private @MonotonicNonNull Handler handler;
        @Nullable
        private VideoFrameProcessor videoFrameProcessor;
        @Nullable
        private CopyOnWriteArrayList<Effect> videoEffects;
        @Nullable
        private Format inputFormat;
        private @MonotonicNonNull Pair<Long, Format> currentFrameFormat;
        @Nullable
        private Pair<Surface, Size> currentSurfaceAndSize;
        private int videoFrameProcessorMaxPendingFrameCount;
        private boolean canEnableFrameProcessing;
        private boolean registeredLastFrame;
        private boolean processedLastFrame;
        private boolean releasedLastFrame;
        private long lastCodecBufferPresentationTimestampUs;
        private VideoSize processedFrameSize;
        private boolean pendingOutputSizeChange;
        private long pendingOutputSizeChangeNotificationTimeUs;
        private long initialStreamOffsetUs;

        public VideoFrameProcessorManager(VideoFrameReleaseHelper frameReleaseHelper, @UnderInitialization MediaCodecVideoRenderer renderer) {
            this.frameReleaseHelper = frameReleaseHelper;
            this.renderer = renderer;
            this.processedFramesTimestampsUs = new ArrayDeque();
            this.pendingFrameFormats = new ArrayDeque();
            this.videoFrameProcessorMaxPendingFrameCount = -1;
            this.canEnableFrameProcessing = true;
            this.lastCodecBufferPresentationTimestampUs = -9223372036854775807L;
            this.processedFrameSize = VideoSize.UNKNOWN;
            this.pendingOutputSizeChangeNotificationTimeUs = -9223372036854775807L;
            this.initialStreamOffsetUs = -9223372036854775807L;
        }

        public void setVideoEffects(List<Effect> videoEffects) {
            if (this.videoEffects == null) {
                this.videoEffects = new CopyOnWriteArrayList<Effect>(videoEffects);
                return;
            }
            this.videoEffects.clear();
            this.videoEffects.addAll(videoEffects);
        }

        public boolean isEnabled() {
            return this.videoFrameProcessor != null;
        }

        public boolean isReady() {
            return this.currentSurfaceAndSize == null || !((Size)this.currentSurfaceAndSize.second).equals((Object)Size.UNKNOWN);
        }

        public boolean releasedLastFrame() {
            return this.releasedLastFrame;
        }

        public void flush() {
            Assertions.checkStateNotNull((Object)this.videoFrameProcessor);
            this.videoFrameProcessor.flush();
            this.processedFramesTimestampsUs.clear();
            this.handler.removeCallbacksAndMessages(null);
            if (this.registeredLastFrame) {
                this.registeredLastFrame = false;
                this.processedLastFrame = false;
                this.releasedLastFrame = false;
            }
        }

        @CanIgnoreReturnValue
        public boolean maybeEnable(final Format inputFormat, long initialStreamOffsetUs) throws ExoPlaybackException {
            Assertions.checkState((!this.isEnabled() ? 1 : 0) != 0);
            if (!this.canEnableFrameProcessing) {
                return false;
            }
            if (this.videoEffects == null) {
                this.canEnableFrameProcessing = false;
                return false;
            }
            this.handler = Util.createHandlerForCurrentLooper();
            Pair<ColorInfo, ColorInfo> inputAndOutputColorInfos = this.renderer.experimentalGetVideoFrameProcessorColorConfiguration(inputFormat.colorInfo);
            try {
                if (!MediaCodecVideoRenderer.codecAppliesRotation() && inputFormat.rotationDegrees != 0) {
                    this.videoEffects.add(0, VideoFrameProcessorAccessor.createRotationEffect(inputFormat.rotationDegrees));
                }
                this.videoFrameProcessor = VideoFrameProcessorAccessor.getFrameProcessorFactory().create(this.renderer.context, (List)Assertions.checkNotNull(this.videoEffects), DebugViewProvider.NONE, (ColorInfo)inputAndOutputColorInfos.first, (ColorInfo)inputAndOutputColorInfos.second, false, arg_0 -> ((Handler)this.handler).post(arg_0), new VideoFrameProcessor.Listener(){

                    public void onOutputSizeChanged(int width, int height) {
                        Format inputFormat2 = inputFormat;
                        Assertions.checkStateNotNull((Object)inputFormat2);
                        processedFrameSize = new VideoSize(width, height, 0, 1.0f);
                        pendingOutputSizeChange = true;
                    }

                    public void onOutputFrameAvailableForRendering(long presentationTimeUs) {
                        if (registeredLastFrame) {
                            Assertions.checkState((lastCodecBufferPresentationTimestampUs != -9223372036854775807L ? 1 : 0) != 0);
                        }
                        processedFramesTimestampsUs.add(presentationTimeUs);
                        if (registeredLastFrame && presentationTimeUs >= lastCodecBufferPresentationTimestampUs) {
                            processedLastFrame = true;
                        }
                        if (pendingOutputSizeChange) {
                            pendingOutputSizeChange = false;
                            pendingOutputSizeChangeNotificationTimeUs = presentationTimeUs;
                        }
                    }

                    public void onError(VideoFrameProcessingException exception) {
                        renderer.setPendingPlaybackException(renderer.createRendererException((Throwable)exception, inputFormat, 7001));
                    }

                    public void onEnded() {
                        throw new IllegalStateException();
                    }
                });
                this.videoFrameProcessor.registerInputStream(1);
                this.initialStreamOffsetUs = initialStreamOffsetUs;
            }
            catch (Exception e) {
                throw this.renderer.createRendererException(e, inputFormat, 7000);
            }
            if (this.currentSurfaceAndSize != null) {
                Size outputSurfaceSize = (Size)this.currentSurfaceAndSize.second;
                this.videoFrameProcessor.setOutputSurfaceInfo(new SurfaceInfo((Surface)this.currentSurfaceAndSize.first, outputSurfaceSize.getWidth(), outputSurfaceSize.getHeight()));
            }
            this.setInputFormat(inputFormat);
            return true;
        }

        public long getCorrectedFramePresentationTimeUs(long framePresentationTimeUs, long currentStreamOffsetUs) {
            Assertions.checkState((this.initialStreamOffsetUs != -9223372036854775807L ? 1 : 0) != 0);
            return framePresentationTimeUs + currentStreamOffsetUs - this.initialStreamOffsetUs;
        }

        public Surface getInputSurface() {
            return ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.videoFrameProcessor)).getInputSurface();
        }

        public void setOutputSurfaceInfo(Surface outputSurface, Size outputResolution) {
            if (this.currentSurfaceAndSize != null && ((Surface)this.currentSurfaceAndSize.first).equals(outputSurface) && ((Size)this.currentSurfaceAndSize.second).equals((Object)outputResolution)) {
                return;
            }
            this.currentSurfaceAndSize = Pair.create((Object)outputSurface, (Object)outputResolution);
            if (this.isEnabled()) {
                ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.videoFrameProcessor)).setOutputSurfaceInfo(new SurfaceInfo(outputSurface, outputResolution.getWidth(), outputResolution.getHeight()));
            }
        }

        public void clearOutputSurfaceInfo() {
            ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.videoFrameProcessor)).setOutputSurfaceInfo(null);
            this.currentSurfaceAndSize = null;
        }

        public void setInputFormat(Format inputFormat) {
            ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.videoFrameProcessor)).setInputFrameInfo(new FrameInfo.Builder(inputFormat.width, inputFormat.height).setPixelWidthHeightRatio(inputFormat.pixelWidthHeightRatio).build());
            this.inputFormat = inputFormat;
            if (this.registeredLastFrame) {
                this.registeredLastFrame = false;
                this.processedLastFrame = false;
                this.releasedLastFrame = false;
            }
        }

        public MediaFormat amendMediaFormatKeys(MediaFormat mediaFormat) {
            if (Util.SDK_INT >= 29 && ((MediaCodecVideoRenderer)this.renderer).context.getApplicationContext().getApplicationInfo().targetSdkVersion >= 29) {
                mediaFormat.setInteger("allow-frame-drop", 0);
            }
            return mediaFormat;
        }

        public void onCodecInitialized(String codecName) {
            this.videoFrameProcessorMaxPendingFrameCount = Util.getMaxPendingFramesCountForMediaCodecDecoders((Context)this.renderer.context, (String)codecName, (boolean)false);
        }

        public boolean maybeRegisterFrame(Format format, long presentationTimestampUs, boolean isLastBuffer) {
            Assertions.checkStateNotNull((Object)this.videoFrameProcessor);
            Assertions.checkState((this.videoFrameProcessorMaxPendingFrameCount != -1 ? 1 : 0) != 0);
            if (this.videoFrameProcessor.getPendingInputFrameCount() < this.videoFrameProcessorMaxPendingFrameCount) {
                this.videoFrameProcessor.registerInputFrame();
                if (this.currentFrameFormat == null) {
                    this.currentFrameFormat = Pair.create((Object)presentationTimestampUs, (Object)format);
                } else if (!Util.areEqual((Object)format, (Object)this.currentFrameFormat.second)) {
                    this.pendingFrameFormats.add((Pair<Long, Format>)Pair.create((Object)presentationTimestampUs, (Object)format));
                }
                if (isLastBuffer) {
                    this.registeredLastFrame = true;
                    this.lastCodecBufferPresentationTimestampUs = presentationTimestampUs;
                }
                return true;
            }
            return false;
        }

        public void releaseProcessedFrames(long positionUs, long elapsedRealtimeUs) {
            Assertions.checkStateNotNull((Object)this.videoFrameProcessor);
            while (!this.processedFramesTimestampsUs.isEmpty()) {
                boolean isStarted = this.renderer.getState() == 2;
                long framePresentationTimeUs = (Long)Assertions.checkNotNull((Object)this.processedFramesTimestampsUs.peek());
                long bufferPresentationTimeUs = framePresentationTimeUs + this.initialStreamOffsetUs;
                long earlyUs = this.renderer.calculateEarlyTimeUs(positionUs, elapsedRealtimeUs, SystemClock.elapsedRealtime() * 1000L, bufferPresentationTimeUs, isStarted);
                boolean isLastFrame = this.processedLastFrame && this.processedFramesTimestampsUs.size() == 1;
                boolean shouldReleaseFrameImmediately = this.renderer.shouldForceRender(positionUs, earlyUs);
                if (shouldReleaseFrameImmediately) {
                    this.releaseProcessedFrameInternal(-1L, isLastFrame);
                    break;
                }
                if (!isStarted || positionUs == this.renderer.initialPositionUs) {
                    return;
                }
                if (earlyUs > 50000L) break;
                this.frameReleaseHelper.onNextFrame(bufferPresentationTimeUs);
                long unadjustedFrameReleaseTimeNs = System.nanoTime() + earlyUs * 1000L;
                long adjustedFrameReleaseTimeNs = this.frameReleaseHelper.adjustReleaseTime(unadjustedFrameReleaseTimeNs);
                earlyUs = (adjustedFrameReleaseTimeNs - System.nanoTime()) / 1000L;
                if (this.renderer.shouldDropOutputBuffer(earlyUs, elapsedRealtimeUs, isLastFrame)) {
                    this.releaseProcessedFrameInternal(-2L, isLastFrame);
                    continue;
                }
                if (!this.pendingFrameFormats.isEmpty() && bufferPresentationTimeUs > (Long)this.pendingFrameFormats.peek().first) {
                    this.currentFrameFormat = this.pendingFrameFormats.remove();
                }
                this.renderer.notifyFrameMetadataListener(framePresentationTimeUs, adjustedFrameReleaseTimeNs, (Format)this.currentFrameFormat.second);
                if (this.pendingOutputSizeChangeNotificationTimeUs >= bufferPresentationTimeUs) {
                    this.pendingOutputSizeChangeNotificationTimeUs = -9223372036854775807L;
                    this.renderer.maybeNotifyVideoSizeChanged(this.processedFrameSize);
                }
                this.releaseProcessedFrameInternal(adjustedFrameReleaseTimeNs, isLastFrame);
            }
        }

        public void reset() {
            ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.videoFrameProcessor)).release();
            this.videoFrameProcessor = null;
            if (this.handler != null) {
                this.handler.removeCallbacksAndMessages(null);
            }
            if (this.videoEffects != null) {
                this.videoEffects.clear();
            }
            this.processedFramesTimestampsUs.clear();
            this.canEnableFrameProcessing = true;
        }

        private void releaseProcessedFrameInternal(long releaseTimeNs, boolean isLastFrame) {
            Assertions.checkStateNotNull((Object)this.videoFrameProcessor);
            this.videoFrameProcessor.renderOutputFrame(releaseTimeNs);
            this.processedFramesTimestampsUs.remove();
            this.renderer.lastRenderRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
            if (releaseTimeNs != -2L) {
                this.renderer.maybeNotifyRenderedFirstFrame();
            }
            if (isLastFrame) {
                this.releasedLastFrame = true;
            }
        }

        private static final class VideoFrameProcessorAccessor {
            private static @MonotonicNonNull Constructor<?> scaleAndRotateTransformationBuilderConstructor;
            private static @MonotonicNonNull Method setRotationMethod;
            private static @MonotonicNonNull Method buildScaleAndRotateTransformationMethod;
            private static @MonotonicNonNull Constructor<?> videoFrameProcessorFactoryBuilderConstructor;
            private static @MonotonicNonNull Method buildVideoFrameProcessorFactoryMethod;

            private VideoFrameProcessorAccessor() {
            }

            public static Effect createRotationEffect(float rotationDegrees) throws Exception {
                VideoFrameProcessorAccessor.prepare();
                Object builder = scaleAndRotateTransformationBuilderConstructor.newInstance(new Object[0]);
                setRotationMethod.invoke(builder, Float.valueOf(rotationDegrees));
                return (Effect)Assertions.checkNotNull((Object)buildScaleAndRotateTransformationMethod.invoke(builder, new Object[0]));
            }

            public static VideoFrameProcessor.Factory getFrameProcessorFactory() throws Exception {
                VideoFrameProcessorAccessor.prepare();
                Object builder = videoFrameProcessorFactoryBuilderConstructor.newInstance(new Object[0]);
                return (VideoFrameProcessor.Factory)Assertions.checkNotNull((Object)buildVideoFrameProcessorFactoryMethod.invoke(builder, new Object[0]));
            }

            @EnsuresNonNull(value={"scaleAndRotateTransformationBuilderConstructor", "setRotationMethod", "buildScaleAndRotateTransformationMethod", "videoFrameProcessorFactoryBuilderConstructor", "buildVideoFrameProcessorFactoryMethod"})
            private static void prepare() throws Exception {
                if (scaleAndRotateTransformationBuilderConstructor == null || setRotationMethod == null || buildScaleAndRotateTransformationMethod == null) {
                    Class<?> scaleAndRotateTransformationBuilderClass = Class.forName("androidx.media3.effect.ScaleAndRotateTransformation$Builder");
                    scaleAndRotateTransformationBuilderConstructor = scaleAndRotateTransformationBuilderClass.getConstructor(new Class[0]);
                    setRotationMethod = scaleAndRotateTransformationBuilderClass.getMethod("setRotationDegrees", Float.TYPE);
                    buildScaleAndRotateTransformationMethod = scaleAndRotateTransformationBuilderClass.getMethod("build", new Class[0]);
                }
                if (videoFrameProcessorFactoryBuilderConstructor == null || buildVideoFrameProcessorFactoryMethod == null) {
                    Class<?> videoFrameProcessorFactoryBuilderClass = Class.forName("androidx.media3.effect.DefaultVideoFrameProcessor$Factory$Builder");
                    videoFrameProcessorFactoryBuilderConstructor = videoFrameProcessorFactoryBuilderClass.getConstructor(new Class[0]);
                    buildVideoFrameProcessorFactoryMethod = videoFrameProcessorFactoryBuilderClass.getMethod("build", new Class[0]);
                }
            }
        }
    }

    @RequiresApi(value=26)
    private static final class Api26 {
        private Api26() {
        }

        @DoNotInline
        public static boolean doesDisplaySupportDolbyVision(Context context) {
            Display display;
            boolean supportsDolbyVision = false;
            DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
            Display display2 = display = displayManager != null ? displayManager.getDisplay(0) : null;
            if (display != null && display.isHdr()) {
                int[] supportedHdrTypes;
                for (int hdrType : supportedHdrTypes = display.getHdrCapabilities().getSupportedHdrTypes()) {
                    if (hdrType != 1) continue;
                    supportsDolbyVision = true;
                    break;
                }
            }
            return supportsDolbyVision;
        }
    }
}

