/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;

public final class VideoSize
implements Bundleable {
    private static final int DEFAULT_WIDTH = 0;
    private static final int DEFAULT_HEIGHT = 0;
    private static final int DEFAULT_UNAPPLIED_ROTATION_DEGREES = 0;
    private static final float DEFAULT_PIXEL_WIDTH_HEIGHT_RATIO = 1.0f;
    public static final VideoSize UNKNOWN = new VideoSize(0, 0);
    @IntRange(from=0L)
    public final int width;
    @IntRange(from=0L)
    public final int height;
    @IntRange(from=0L, to=359L)
    public final int unappliedRotationDegrees;
    @FloatRange(from=0.0, fromInclusive=false)
    public final float pixelWidthHeightRatio;
    private static final String FIELD_WIDTH = Util.intToStringMaxRadix(0);
    private static final String FIELD_HEIGHT = Util.intToStringMaxRadix(1);
    private static final String FIELD_UNAPPLIED_ROTATION_DEGREES = Util.intToStringMaxRadix(2);
    private static final String FIELD_PIXEL_WIDTH_HEIGHT_RATIO = Util.intToStringMaxRadix(3);
    @UnstableApi
    public static final Bundleable.Creator<VideoSize> CREATOR = bundle -> {
        int width = bundle.getInt(FIELD_WIDTH, 0);
        int height = bundle.getInt(FIELD_HEIGHT, 0);
        int unappliedRotationDegrees = bundle.getInt(FIELD_UNAPPLIED_ROTATION_DEGREES, 0);
        float pixelWidthHeightRatio = bundle.getFloat(FIELD_PIXEL_WIDTH_HEIGHT_RATIO, 1.0f);
        return new VideoSize(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
    };

    @UnstableApi
    public VideoSize(@IntRange(from=0L) int width, @IntRange(from=0L) int height) {
        this(width, height, 0, 1.0f);
    }

    @UnstableApi
    public VideoSize(@IntRange(from=0L) int width, @IntRange(from=0L) int height, @IntRange(from=0L, to=359L) int unappliedRotationDegrees, @FloatRange(from=0.0, fromInclusive=false) float pixelWidthHeightRatio) {
        this.width = width;
        this.height = height;
        this.unappliedRotationDegrees = unappliedRotationDegrees;
        this.pixelWidthHeightRatio = pixelWidthHeightRatio;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VideoSize) {
            VideoSize other = (VideoSize)obj;
            return this.width == other.width && this.height == other.height && this.unappliedRotationDegrees == other.unappliedRotationDegrees && this.pixelWidthHeightRatio == other.pixelWidthHeightRatio;
        }
        return false;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.unappliedRotationDegrees;
        result = 31 * result + Float.floatToRawIntBits(this.pixelWidthHeightRatio);
        return result;
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(FIELD_WIDTH, this.width);
        bundle.putInt(FIELD_HEIGHT, this.height);
        bundle.putInt(FIELD_UNAPPLIED_ROTATION_DEGREES, this.unappliedRotationDegrees);
        bundle.putFloat(FIELD_PIXEL_WIDTH_HEIGHT_RATIO, this.pixelWidthHeightRatio);
        return bundle;
    }
}

