/*
 * Decompiled with CFR 0.152.
 */
package com.renderheads.AVPro.Video;

import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.BaseAudioProcessor;
import com.renderheads.AVPro.Video.AudioInfoListener;
import java.nio.ByteBuffer;

public class PanAudioProcessor
extends BaseAudioProcessor {
    private float m_fPan = 0.0f;
    private AudioInfoListener m_AudioInfoListener;

    public PanAudioProcessor(AudioInfoListener audioInfoListener) {
        this.m_AudioInfoListener = audioInfoListener;
    }

    public void setPan(float f) {
        this.m_fPan = Math.max(-1.0f, Math.min(1.0f, f));
    }

    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat audioFormat) {
        AudioInfoListener audioInfoListener = ((PanAudioProcessor)((Object)audioInfoListener)).m_AudioInfoListener;
        if (audioInfoListener != null) {
            audioInfoListener.NumberOfChannelsChanged(audioFormat.channelCount);
        }
        if (audioFormat.encoding == 2) {
            AudioProcessor.AudioFormat audioFormat2 = audioFormat;
            int n = audioFormat2.sampleRate;
            return new AudioProcessor.AudioFormat(n, audioFormat2.channelCount, 2);
        }
        throw new AudioProcessor.UnhandledAudioFormatException(audioFormat);
    }

    public void queueInput(ByteBuffer byteBuffer) {
        if (this.inputAudioFormat.channelCount != 2) {
            int n = byteBuffer.remaining();
            if (n > 0) {
                this.replaceOutputBuffer(n).put(byteBuffer).flip();
            }
        } else {
            PanAudioProcessor panAudioProcessor = this;
            ByteBuffer byteBuffer2 = byteBuffer;
            int n = byteBuffer2.position();
            int n2 = byteBuffer2.limit();
            ByteBuffer byteBuffer3 = panAudioProcessor.replaceOutputBuffer((n2 - n) / this.inputAudioFormat.bytesPerFrame * this.outputAudioFormat.bytesPerFrame);
            float f = Math.max(Math.min(Math.abs(panAudioProcessor.m_fPan - 1.0f), 1.0f), 0.0f);
            float f2 = Math.max(Math.min(panAudioProcessor.m_fPan + 1.0f, 1.0f), 0.0f);
            while (n < n2) {
                int n3;
                float f3 = f;
                for (int i = 0; i < (n3 = this.inputAudioFormat.channelCount); ++i) {
                    byteBuffer3.putShort((short)((float)byteBuffer.getShort(i * 2 + n) * f3));
                    f3 = f2;
                }
                n = n3 * 2 + n;
            }
            byteBuffer.position(n2);
            byteBuffer3.flip();
        }
    }
}

