/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.container;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.FloatRange;
import androidx.annotation.Nullable;
import androidx.media3.common.Metadata;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import com.google.common.primitives.Floats;

@UnstableApi
public final class Mp4LocationData
implements Metadata.Entry {
    public final float latitude;
    public final float longitude;
    public static final Parcelable.Creator<Mp4LocationData> CREATOR = new Parcelable.Creator<Mp4LocationData>(){

        public Mp4LocationData createFromParcel(Parcel in) {
            return new Mp4LocationData(in);
        }

        public Mp4LocationData[] newArray(int size) {
            return new Mp4LocationData[size];
        }
    };

    public Mp4LocationData(@FloatRange(from=-90.0, to=90.0) float latitude, @FloatRange(from=-180.0, to=180.0) float longitude) {
        Assertions.checkArgument((latitude >= -90.0f && latitude <= 90.0f && longitude >= -180.0f && longitude <= 180.0f ? 1 : 0) != 0, (Object)"Invalid latitude or longitude");
        this.latitude = latitude;
        this.longitude = longitude;
    }

    private Mp4LocationData(Parcel in) {
        this.latitude = in.readFloat();
        this.longitude = in.readFloat();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Mp4LocationData other = (Mp4LocationData)obj;
        return this.latitude == other.latitude && this.longitude == other.longitude;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Floats.hashCode((float)this.latitude);
        result = 31 * result + Floats.hashCode((float)this.longitude);
        return result;
    }

    public String toString() {
        return "xyz: latitude=" + this.latitude + ", longitude=" + this.longitude;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.latitude);
        dest.writeFloat(this.longitude);
    }
}

