/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.MediaClock;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.RendererConfiguration;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.source.SampleStream;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public abstract class NoSampleRenderer
implements Renderer,
RendererCapabilities {
    private @MonotonicNonNull RendererConfiguration configuration;
    private int index;
    private int state;
    @Nullable
    private SampleStream stream;
    private boolean streamIsFinal;

    @Override
    public final int getTrackType() {
        return -2;
    }

    @Override
    public final RendererCapabilities getCapabilities() {
        return this;
    }

    @Override
    public final void init(int index, PlayerId playerId) {
        this.index = index;
    }

    @Override
    @Nullable
    public MediaClock getMediaClock() {
        return null;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public final void enable(RendererConfiguration configuration, Format[] formats, SampleStream stream, long positionUs, boolean joining, boolean mayRenderStartOfStream, long startPositionUs, long offsetUs) throws ExoPlaybackException {
        Assertions.checkState((this.state == 0 ? 1 : 0) != 0);
        this.configuration = configuration;
        this.state = 1;
        this.onEnabled(joining);
        this.replaceStream(formats, stream, startPositionUs, offsetUs);
        this.onPositionReset(positionUs, joining);
    }

    @Override
    public final void start() throws ExoPlaybackException {
        Assertions.checkState((this.state == 1 ? 1 : 0) != 0);
        this.state = 2;
        this.onStarted();
    }

    @Override
    public final void replaceStream(Format[] formats, SampleStream stream, long startPositionUs, long offsetUs) throws ExoPlaybackException {
        Assertions.checkState((!this.streamIsFinal ? 1 : 0) != 0);
        this.stream = stream;
        this.onRendererOffsetChanged(offsetUs);
    }

    @Override
    @Nullable
    public final SampleStream getStream() {
        return this.stream;
    }

    @Override
    public final boolean hasReadStreamToEnd() {
        return true;
    }

    @Override
    public long getReadingPositionUs() {
        return Long.MIN_VALUE;
    }

    @Override
    public final void setCurrentStreamFinal() {
        this.streamIsFinal = true;
    }

    @Override
    public final boolean isCurrentStreamFinal() {
        return this.streamIsFinal;
    }

    @Override
    public final void maybeThrowStreamError() throws IOException {
    }

    @Override
    public final void resetPosition(long positionUs) throws ExoPlaybackException {
        this.streamIsFinal = false;
        this.onPositionReset(positionUs, false);
    }

    @Override
    public final void stop() {
        Assertions.checkState((this.state == 2 ? 1 : 0) != 0);
        this.state = 1;
        this.onStopped();
    }

    @Override
    public final void disable() {
        Assertions.checkState((this.state == 1 ? 1 : 0) != 0);
        this.state = 0;
        this.stream = null;
        this.streamIsFinal = false;
        this.onDisabled();
    }

    @Override
    public final void reset() {
        Assertions.checkState((this.state == 0 ? 1 : 0) != 0);
        this.onReset();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isEnded() {
        return true;
    }

    @Override
    public int supportsFormat(Format format) throws ExoPlaybackException {
        return RendererCapabilities.create(0);
    }

    @Override
    public int supportsMixedMimeTypeAdaptation() throws ExoPlaybackException {
        return 0;
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
    }

    protected void onEnabled(boolean joining) throws ExoPlaybackException {
    }

    protected void onRendererOffsetChanged(long offsetUs) throws ExoPlaybackException {
    }

    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
    }

    protected void onStarted() throws ExoPlaybackException {
    }

    protected void onStopped() {
    }

    protected void onDisabled() {
    }

    protected void onReset() {
    }

    @Nullable
    protected final RendererConfiguration getConfiguration() {
        return this.configuration;
    }

    protected final int getIndex() {
        return this.index;
    }
}

