/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video.spherical;

import android.opengl.Matrix;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.TimedValueQueue;

final class FrameRotationQueue {
    private final float[] recenterMatrix = new float[16];
    private final float[] rotationMatrix = new float[16];
    private final TimedValueQueue<float[]> rotations = new TimedValueQueue();
    private boolean recenterMatrixComputed;

    public void setRotation(long timestampUs, float[] angleAxis) {
        this.rotations.add(timestampUs, (Object)angleAxis);
    }

    public void reset() {
        this.rotations.clear();
        this.recenterMatrixComputed = false;
    }

    public boolean pollRotationMatrix(float[] matrix, long timestampUs) {
        float[] rotation = (float[])this.rotations.pollFloor(timestampUs);
        if (rotation == null) {
            return false;
        }
        FrameRotationQueue.getRotationMatrixFromAngleAxis(this.rotationMatrix, rotation);
        if (!this.recenterMatrixComputed) {
            FrameRotationQueue.computeRecenterMatrix(this.recenterMatrix, this.rotationMatrix);
            this.recenterMatrixComputed = true;
        }
        Matrix.multiplyMM((float[])matrix, (int)0, (float[])this.recenterMatrix, (int)0, (float[])this.rotationMatrix, (int)0);
        return true;
    }

    public static void computeRecenterMatrix(float[] recenterMatrix, float[] rotationMatrix) {
        GlUtil.setToIdentity((float[])recenterMatrix);
        float normRowSqr = rotationMatrix[10] * rotationMatrix[10] + rotationMatrix[8] * rotationMatrix[8];
        float normRow = (float)Math.sqrt(normRowSqr);
        recenterMatrix[0] = rotationMatrix[10] / normRow;
        recenterMatrix[2] = rotationMatrix[8] / normRow;
        recenterMatrix[8] = -rotationMatrix[8] / normRow;
        recenterMatrix[10] = rotationMatrix[10] / normRow;
    }

    private static void getRotationMatrixFromAngleAxis(float[] matrix, float[] angleAxis) {
        float x = angleAxis[0];
        float y = -angleAxis[1];
        float z = -angleAxis[2];
        float angleRad = Matrix.length((float)x, (float)y, (float)z);
        if (angleRad != 0.0f) {
            float angleDeg = (float)Math.toDegrees(angleRad);
            Matrix.setRotateM((float[])matrix, (int)0, (float)angleDeg, (float)(x / angleRad), (float)(y / angleRad), (float)(z / angleRad));
        } else {
            GlUtil.setToIdentity((float[])matrix);
        }
    }
}

