/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.metadata.id3;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.metadata.id3.Id3Frame;
import java.util.Arrays;

@UnstableApi
public final class GeobFrame
extends Id3Frame {
    public static final String ID = "GEOB";
    public final String mimeType;
    public final String filename;
    public final String description;
    public final byte[] data;
    public static final Parcelable.Creator<GeobFrame> CREATOR = new Parcelable.Creator<GeobFrame>(){

        public GeobFrame createFromParcel(Parcel in) {
            return new GeobFrame(in);
        }

        public GeobFrame[] newArray(int size) {
            return new GeobFrame[size];
        }
    };

    public GeobFrame(String mimeType, String filename, String description, byte[] data) {
        super(ID);
        this.mimeType = mimeType;
        this.filename = filename;
        this.description = description;
        this.data = data;
    }

    GeobFrame(Parcel in) {
        super(ID);
        this.mimeType = (String)Util.castNonNull((Object)in.readString());
        this.filename = (String)Util.castNonNull((Object)in.readString());
        this.description = (String)Util.castNonNull((Object)in.readString());
        this.data = (byte[])Util.castNonNull((Object)in.createByteArray());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeobFrame other = (GeobFrame)obj;
        return Util.areEqual((Object)this.mimeType, (Object)other.mimeType) && Util.areEqual((Object)this.filename, (Object)other.filename) && Util.areEqual((Object)this.description, (Object)other.description) && Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        result = 31 * result + (this.filename != null ? this.filename.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public String toString() {
        return this.id + ": mimeType=" + this.mimeType + ", filename=" + this.filename + ", description=" + this.description;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mimeType);
        dest.writeString(this.filename);
        dest.writeString(this.description);
        dest.writeByteArray(this.data);
    }
}

