/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp4;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.TrackOutput;

@UnstableApi
public final class TrackEncryptionBox {
    private static final String TAG = "TrackEncryptionBox";
    public final boolean isEncrypted;
    @Nullable
    public final String schemeType;
    public final TrackOutput.CryptoData cryptoData;
    public final int perSampleIvSize;
    @Nullable
    public final byte[] defaultInitializationVector;

    public TrackEncryptionBox(boolean isEncrypted, @Nullable String schemeType, int perSampleIvSize, byte[] keyId, int defaultEncryptedBlocks, int defaultClearBlocks, @Nullable byte[] defaultInitializationVector) {
        Assertions.checkArgument((boolean)(perSampleIvSize == 0 ^ defaultInitializationVector == null));
        this.isEncrypted = isEncrypted;
        this.schemeType = schemeType;
        this.perSampleIvSize = perSampleIvSize;
        this.defaultInitializationVector = defaultInitializationVector;
        this.cryptoData = new TrackOutput.CryptoData(TrackEncryptionBox.schemeToCryptoMode(schemeType), keyId, defaultEncryptedBlocks, defaultClearBlocks);
    }

    private static int schemeToCryptoMode(@Nullable String schemeType) {
        if (schemeType == null) {
            return 1;
        }
        switch (schemeType) {
            case "cenc": 
            case "cens": {
                return 1;
            }
            case "cbc1": 
            case "cbcs": {
                return 2;
            }
        }
        Log.w((String)TAG, (String)("Unsupported protection scheme type '" + schemeType + "'. Assuming AES-CTR crypto mode."));
        return 1;
    }
}

