/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.subrip;

import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.text.Subtitle;
import java.util.Collections;
import java.util.List;

final class SubripSubtitle
implements Subtitle {
    private final Cue[] cues;
    private final long[] cueTimesUs;

    public SubripSubtitle(Cue[] cues, long[] cueTimesUs) {
        this.cues = cues;
        this.cueTimesUs = cueTimesUs;
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        int index = Util.binarySearchCeil((long[])this.cueTimesUs, (long)timeUs, (boolean)false, (boolean)false);
        return index < this.cueTimesUs.length ? index : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.cueTimesUs.length;
    }

    @Override
    public long getEventTime(int index) {
        Assertions.checkArgument((index >= 0 ? 1 : 0) != 0);
        Assertions.checkArgument((index < this.cueTimesUs.length ? 1 : 0) != 0);
        return this.cueTimesUs[index];
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        int index = Util.binarySearchFloor((long[])this.cueTimesUs, (long)timeUs, (boolean)true, (boolean)false);
        if (index == -1 || this.cues[index] == Cue.EMPTY) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.cues[index]);
    }
}

