/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.Audio360JNI;
import com.twobigears.audio360.ChannelMap;
import com.twobigears.audio360.EventListener;
import com.twobigears.audio360.SpatDecoderInterface;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class SpatDecoderQueue
extends SpatDecoderInterface {
    private transient long swigCPtr;
    private EventListener eventListener_;

    protected SpatDecoderQueue(long cPtr, boolean cMemoryOwn) {
        super(Audio360JNI.SpatDecoderQueue_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(SpatDecoderQueue obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setEventListener(EventListener listener) {
        if (this.eventListener_ != null) {
            this.eventListener_.delete();
            this.eventListener_ = null;
        }
        this.eventListener_ = listener;
        this.setEventListenerInternal(this.eventListener_);
    }

    public int getFreeSpaceInQueue(ChannelMap channelMap) {
        return Audio360JNI.SpatDecoderQueue_getFreeSpaceInQueue(this.swigCPtr, this, channelMap.swigValue());
    }

    public int getQueueSize(ChannelMap channelMap) {
        return Audio360JNI.SpatDecoderQueue_getQueueSize(this.swigCPtr, this, channelMap.swigValue());
    }

    public int enqueueSilence(int numTotalSamples, ChannelMap channelMap) {
        return Audio360JNI.SpatDecoderQueue_enqueueSilence(this.swigCPtr, this, numTotalSamples, channelMap.swigValue());
    }

    public void flushQueue() {
        Audio360JNI.SpatDecoderQueue_flushQueue(this.swigCPtr, this);
    }

    public BigInteger getNumSamplesDequeuedPerChannel() {
        return Audio360JNI.SpatDecoderQueue_getNumSamplesDequeuedPerChannel(this.swigCPtr, this);
    }

    public void setEndOfStream(boolean endOfStream) {
        Audio360JNI.SpatDecoderQueue_setEndOfStream(this.swigCPtr, this, endOfStream);
    }

    public boolean getEndOfStreamStatus() {
        return Audio360JNI.SpatDecoderQueue_getEndOfStreamStatus(this.swigCPtr, this);
    }

    public int enqueueDataInt16(ByteBuffer interleavedBuffer, int numTotalSamples, ChannelMap channelMap) {
        return Audio360JNI.SpatDecoderQueue_enqueueDataInt16(this.swigCPtr, this, interleavedBuffer, numTotalSamples, channelMap.swigValue());
    }

    public int enqueueDataFloat(ByteBuffer interleavedBuffer, int numTotalSamples, ChannelMap channelMap) {
        return Audio360JNI.SpatDecoderQueue_enqueueDataFloat(this.swigCPtr, this, interleavedBuffer, numTotalSamples, channelMap.swigValue());
    }

    private void setEventListenerInternal(EventListener listener) {
        Audio360JNI.SpatDecoderQueue_setEventListenerInternal(this.swigCPtr, this, EventListener.getCPtr(listener), listener);
    }
}

