/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.dash.manifest;

import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.dash.manifest.AdaptationSet;
import androidx.media3.exoplayer.dash.manifest.Descriptor;
import androidx.media3.exoplayer.dash.manifest.EventStream;
import java.util.Collections;
import java.util.List;

@UnstableApi
public class Period {
    @Nullable
    public final String id;
    public final long startMs;
    public final List<AdaptationSet> adaptationSets;
    public final List<EventStream> eventStreams;
    @Nullable
    public final Descriptor assetIdentifier;

    public Period(@Nullable String id, long startMs, List<AdaptationSet> adaptationSets) {
        this(id, startMs, adaptationSets, Collections.emptyList(), null);
    }

    public Period(@Nullable String id, long startMs, List<AdaptationSet> adaptationSets, List<EventStream> eventStreams) {
        this(id, startMs, adaptationSets, eventStreams, null);
    }

    public Period(@Nullable String id, long startMs, List<AdaptationSet> adaptationSets, List<EventStream> eventStreams, @Nullable Descriptor assetIdentifier) {
        this.id = id;
        this.startMs = startMs;
        this.adaptationSets = Collections.unmodifiableList(adaptationSets);
        this.eventStreams = Collections.unmodifiableList(eventStreams);
        this.assetIdentifier = assetIdentifier;
    }

    public int getAdaptationSetIndex(int type) {
        int adaptationCount = this.adaptationSets.size();
        for (int i = 0; i < adaptationCount; ++i) {
            if (this.adaptationSets.get((int)i).type != type) continue;
            return i;
        }
        return -1;
    }
}

