/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.Format;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.CodecSpecificDataUtil;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.container.NalUnitUtil;
import androidx.media3.exoplayer.rtsp.MediaDescription;
import androidx.media3.exoplayer.rtsp.RtpPayloadFormat;
import androidx.media3.exoplayer.rtsp.RtspHeaders;
import androidx.media3.extractor.AacUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

@UnstableApi
final class RtspMediaTrack {
    private static final String PARAMETER_PROFILE_LEVEL_ID = "profile-level-id";
    private static final String PARAMETER_SPROP_PARAMS = "sprop-parameter-sets";
    private static final String PARAMETER_AMR_OCTET_ALIGN = "octet-align";
    private static final String PARAMETER_AMR_INTERLEAVING = "interleaving";
    private static final String PARAMETER_H265_SPROP_SPS = "sprop-sps";
    private static final String PARAMETER_H265_SPROP_PPS = "sprop-pps";
    private static final String PARAMETER_H265_SPROP_VPS = "sprop-vps";
    private static final String PARAMETER_H265_SPROP_MAX_DON_DIFF = "sprop-max-don-diff";
    private static final String PARAMETER_MP4A_CONFIG = "config";
    private static final String PARAMETER_MP4A_C_PRESENT = "cpresent";
    private static final String AAC_CODECS_PREFIX = "mp4a.40.";
    private static final String H264_CODECS_PREFIX = "avc1.";
    private static final String MPEG4_CODECS_PREFIX = "mp4v.";
    private static final String GENERIC_CONTROL_ATTR = "*";
    private static final int DEFAULT_MP4V_WIDTH = 352;
    private static final int DEFAULT_MP4V_HEIGHT = 288;
    private static final int DEFAULT_VP8_WIDTH = 320;
    private static final int DEFAULT_VP8_HEIGHT = 240;
    private static final int OPUS_CLOCK_RATE = 48000;
    private static final int DEFAULT_VP9_WIDTH = 320;
    private static final int DEFAULT_VP9_HEIGHT = 240;
    private static final int DEFAULT_H263_WIDTH = 352;
    private static final int DEFAULT_H263_HEIGHT = 288;
    public final RtpPayloadFormat payloadFormat;
    public final Uri uri;

    public RtspMediaTrack(RtspHeaders rtspHeaders, MediaDescription mediaDescription, Uri sessionUri) {
        Assertions.checkArgument((boolean)mediaDescription.attributes.containsKey((Object)"control"), (Object)"missing attribute control");
        this.payloadFormat = RtspMediaTrack.generatePayloadFormat(mediaDescription);
        this.uri = RtspMediaTrack.extractTrackUri(rtspHeaders, sessionUri, (String)Util.castNonNull((Object)((String)mediaDescription.attributes.get((Object)"control"))));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RtspMediaTrack that = (RtspMediaTrack)o;
        return this.payloadFormat.equals(that.payloadFormat) && this.uri.equals((Object)that.uri);
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.payloadFormat.hashCode();
        result = 31 * result + this.uri.hashCode();
        return result;
    }

    @VisibleForTesting
    static RtpPayloadFormat generatePayloadFormat(MediaDescription mediaDescription) {
        Format.Builder formatBuilder = new Format.Builder();
        if (mediaDescription.bitrate > 0) {
            formatBuilder.setAverageBitrate(mediaDescription.bitrate);
        }
        int rtpPayloadType = mediaDescription.rtpMapAttribute.payloadType;
        String mediaEncoding = mediaDescription.rtpMapAttribute.mediaEncoding;
        String mimeType = RtpPayloadFormat.getMimeTypeFromRtpMediaType(mediaEncoding);
        formatBuilder.setSampleMimeType(mimeType);
        int clockRate = mediaDescription.rtpMapAttribute.clockRate;
        int channelCount = -1;
        if ("audio".equals(mediaDescription.mediaType)) {
            channelCount = RtspMediaTrack.inferChannelCount(mediaDescription.rtpMapAttribute.encodingParameters, mimeType);
            formatBuilder.setSampleRate(clockRate).setChannelCount(channelCount);
        }
        ImmutableMap<String, String> fmtpParameters = mediaDescription.getFmtpParametersAsMap();
        switch (mimeType) {
            case "audio/mp4a-latm": {
                Assertions.checkArgument((channelCount != -1 ? 1 : 0) != 0);
                Assertions.checkArgument((!fmtpParameters.isEmpty() ? 1 : 0) != 0, (Object)"missing attribute fmtp");
                if (mediaEncoding.equals("MP4A-LATM")) {
                    Assertions.checkArgument((fmtpParameters.containsKey((Object)PARAMETER_MP4A_C_PRESENT) && ((String)fmtpParameters.get((Object)PARAMETER_MP4A_C_PRESENT)).equals("0") ? 1 : 0) != 0, (Object)"Only supports cpresent=0 in AAC audio.");
                    String config = (String)fmtpParameters.get((Object)PARAMETER_MP4A_CONFIG);
                    Assertions.checkNotNull((Object)config, (Object)"AAC audio stream must include config fmtp parameter");
                    Assertions.checkArgument((config.length() % 2 == 0 ? 1 : 0) != 0, (Object)("Malformat MPEG4 config: " + config));
                    AacUtil.Config aacConfig = RtspMediaTrack.parseAacStreamMuxConfig(config);
                    formatBuilder.setSampleRate(aacConfig.sampleRateHz).setChannelCount(aacConfig.channelCount).setCodecs(aacConfig.codecs);
                }
                RtspMediaTrack.processAacFmtpAttribute(formatBuilder, fmtpParameters, mediaEncoding, channelCount, clockRate);
                break;
            }
            case "audio/3gpp": 
            case "audio/amr-wb": {
                Assertions.checkArgument((channelCount == 1 ? 1 : 0) != 0, (Object)"Multi channel AMR is not currently supported.");
                Assertions.checkArgument((!fmtpParameters.isEmpty() ? 1 : 0) != 0, (Object)"fmtp parameters must include octet-align.");
                Assertions.checkArgument((boolean)fmtpParameters.containsKey((Object)PARAMETER_AMR_OCTET_ALIGN), (Object)"Only octet aligned mode is currently supported.");
                Assertions.checkArgument((!fmtpParameters.containsKey((Object)PARAMETER_AMR_INTERLEAVING) ? 1 : 0) != 0, (Object)"Interleaving mode is not currently supported.");
                break;
            }
            case "audio/opus": {
                Assertions.checkArgument((channelCount != -1 ? 1 : 0) != 0);
                Assertions.checkArgument((clockRate == 48000 ? 1 : 0) != 0, (Object)"Invalid OPUS clock rate.");
                break;
            }
            case "video/mp4v-es": {
                Assertions.checkArgument((!fmtpParameters.isEmpty() ? 1 : 0) != 0);
                RtspMediaTrack.processMPEG4FmtpAttribute(formatBuilder, fmtpParameters);
                break;
            }
            case "video/3gpp": {
                formatBuilder.setWidth(352).setHeight(288);
                break;
            }
            case "video/avc": {
                Assertions.checkArgument((!fmtpParameters.isEmpty() ? 1 : 0) != 0, (Object)"missing attribute fmtp");
                RtspMediaTrack.processH264FmtpAttribute(formatBuilder, fmtpParameters);
                break;
            }
            case "video/hevc": {
                Assertions.checkArgument((!fmtpParameters.isEmpty() ? 1 : 0) != 0, (Object)"missing attribute fmtp");
                RtspMediaTrack.processH265FmtpAttribute(formatBuilder, fmtpParameters);
                break;
            }
            case "video/x-vnd.on2.vp8": {
                formatBuilder.setWidth(320).setHeight(240);
                break;
            }
            case "video/x-vnd.on2.vp9": {
                formatBuilder.setWidth(320).setHeight(240);
                break;
            }
            case "audio/raw": {
                formatBuilder.setPcmEncoding(RtpPayloadFormat.getRawPcmEncodingType(mediaEncoding));
                break;
            }
        }
        Assertions.checkArgument((clockRate > 0 ? 1 : 0) != 0);
        return new RtpPayloadFormat(formatBuilder.build(), rtpPayloadType, clockRate, (Map<String, String>)fmtpParameters, mediaEncoding);
    }

    private static int inferChannelCount(int encodingParameter, String mimeType) {
        if (encodingParameter != -1) {
            return encodingParameter;
        }
        if (mimeType.equals("audio/ac3")) {
            return 6;
        }
        return 1;
    }

    private static void processAacFmtpAttribute(Format.Builder formatBuilder, ImmutableMap<String, String> fmtpAttributes, String mediaEncoding, int channelCount, int sampleRate) {
        String profileLevel = (String)fmtpAttributes.get((Object)PARAMETER_PROFILE_LEVEL_ID);
        if (profileLevel == null && mediaEncoding.equals("MP4A-LATM")) {
            profileLevel = "30";
        }
        Assertions.checkArgument((profileLevel != null && !profileLevel.isEmpty() ? 1 : 0) != 0, (Object)"missing profile-level-id param");
        formatBuilder.setCodecs(AAC_CODECS_PREFIX + profileLevel);
        formatBuilder.setInitializationData((List)ImmutableList.of((Object)AacUtil.buildAacLcAudioSpecificConfig((int)sampleRate, (int)channelCount)));
    }

    private static AacUtil.Config parseAacStreamMuxConfig(String streamMuxConfig) {
        ParsableBitArray config = new ParsableBitArray(Util.getBytesFromHexString((String)streamMuxConfig));
        Assertions.checkArgument((config.readBits(1) == 0 ? 1 : 0) != 0, (Object)"Only supports audio mux version 0.");
        Assertions.checkArgument((config.readBits(1) == 1 ? 1 : 0) != 0, (Object)"Only supports allStreamsSameTimeFraming.");
        config.skipBits(6);
        Assertions.checkArgument((config.readBits(4) == 0 ? 1 : 0) != 0, (Object)"Only supports one program.");
        Assertions.checkArgument((config.readBits(3) == 0 ? 1 : 0) != 0, (Object)"Only supports one numLayer.");
        try {
            return AacUtil.parseAudioSpecificConfig((ParsableBitArray)config, (boolean)false);
        }
        catch (ParserException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void processMPEG4FmtpAttribute(Format.Builder formatBuilder, ImmutableMap<String, String> fmtpAttributes) {
        String configInput = (String)fmtpAttributes.get((Object)PARAMETER_MP4A_CONFIG);
        if (configInput != null) {
            byte[] configBuffer = Util.getBytesFromHexString((String)configInput);
            formatBuilder.setInitializationData((List)ImmutableList.of((Object)configBuffer));
            Pair resolution = CodecSpecificDataUtil.getVideoResolutionFromMpeg4VideoConfig((byte[])configBuffer);
            formatBuilder.setWidth(((Integer)resolution.first).intValue()).setHeight(((Integer)resolution.second).intValue());
        } else {
            formatBuilder.setWidth(352).setHeight(288);
        }
        String profileLevel = (String)fmtpAttributes.get((Object)PARAMETER_PROFILE_LEVEL_ID);
        formatBuilder.setCodecs(MPEG4_CODECS_PREFIX + (profileLevel == null ? "1" : profileLevel));
    }

    private static byte[] getInitializationDataFromParameterSet(String parameterSet) {
        byte[] decodedParameterNalData = Base64.decode((String)parameterSet, (int)0);
        byte[] decodedParameterNalUnit = new byte[decodedParameterNalData.length + NalUnitUtil.NAL_START_CODE.length];
        System.arraycopy(NalUnitUtil.NAL_START_CODE, 0, decodedParameterNalUnit, 0, NalUnitUtil.NAL_START_CODE.length);
        System.arraycopy(decodedParameterNalData, 0, decodedParameterNalUnit, NalUnitUtil.NAL_START_CODE.length, decodedParameterNalData.length);
        return decodedParameterNalUnit;
    }

    private static void processH264FmtpAttribute(Format.Builder formatBuilder, ImmutableMap<String, String> fmtpAttributes) {
        Assertions.checkArgument((boolean)fmtpAttributes.containsKey((Object)PARAMETER_SPROP_PARAMS), (Object)"missing sprop parameter");
        String spropParameterSets = (String)Assertions.checkNotNull((Object)((String)fmtpAttributes.get((Object)PARAMETER_SPROP_PARAMS)));
        String[] parameterSets = Util.split((String)spropParameterSets, (String)",");
        Assertions.checkArgument((parameterSets.length == 2 ? 1 : 0) != 0, (Object)"empty sprop value");
        ImmutableList initializationData = ImmutableList.of((Object)RtspMediaTrack.getInitializationDataFromParameterSet(parameterSets[0]), (Object)RtspMediaTrack.getInitializationDataFromParameterSet(parameterSets[1]));
        formatBuilder.setInitializationData((List)initializationData);
        byte[] spsNalDataWithStartCode = (byte[])initializationData.get(0);
        NalUnitUtil.SpsData spsData = NalUnitUtil.parseSpsNalUnit((byte[])spsNalDataWithStartCode, (int)NalUnitUtil.NAL_START_CODE.length, (int)spsNalDataWithStartCode.length);
        formatBuilder.setPixelWidthHeightRatio(spsData.pixelWidthHeightRatio);
        formatBuilder.setHeight(spsData.height);
        formatBuilder.setWidth(spsData.width);
        String profileLevel = (String)fmtpAttributes.get((Object)PARAMETER_PROFILE_LEVEL_ID);
        if (profileLevel != null) {
            formatBuilder.setCodecs(H264_CODECS_PREFIX + profileLevel);
        } else {
            formatBuilder.setCodecs(CodecSpecificDataUtil.buildAvcCodecString((int)spsData.profileIdc, (int)spsData.constraintsFlagsAndReservedZero2Bits, (int)spsData.levelIdc));
        }
    }

    private static void processH265FmtpAttribute(Format.Builder formatBuilder, ImmutableMap<String, String> fmtpAttributes) {
        if (fmtpAttributes.containsKey((Object)PARAMETER_H265_SPROP_MAX_DON_DIFF)) {
            int maxDonDiff = Integer.parseInt((String)Assertions.checkNotNull((Object)((String)fmtpAttributes.get((Object)PARAMETER_H265_SPROP_MAX_DON_DIFF))));
            Assertions.checkArgument((maxDonDiff == 0 ? 1 : 0) != 0, (Object)("non-zero sprop-max-don-diff " + maxDonDiff + " is not supported"));
        }
        Assertions.checkArgument((boolean)fmtpAttributes.containsKey((Object)PARAMETER_H265_SPROP_VPS), (Object)"missing sprop-vps parameter");
        String spropVPS = (String)Assertions.checkNotNull((Object)((String)fmtpAttributes.get((Object)PARAMETER_H265_SPROP_VPS)));
        Assertions.checkArgument((boolean)fmtpAttributes.containsKey((Object)PARAMETER_H265_SPROP_SPS), (Object)"missing sprop-sps parameter");
        String spropSPS = (String)Assertions.checkNotNull((Object)((String)fmtpAttributes.get((Object)PARAMETER_H265_SPROP_SPS)));
        Assertions.checkArgument((boolean)fmtpAttributes.containsKey((Object)PARAMETER_H265_SPROP_PPS), (Object)"missing sprop-pps parameter");
        String spropPPS = (String)Assertions.checkNotNull((Object)((String)fmtpAttributes.get((Object)PARAMETER_H265_SPROP_PPS)));
        ImmutableList initializationData = ImmutableList.of((Object)RtspMediaTrack.getInitializationDataFromParameterSet(spropVPS), (Object)RtspMediaTrack.getInitializationDataFromParameterSet(spropSPS), (Object)RtspMediaTrack.getInitializationDataFromParameterSet(spropPPS));
        formatBuilder.setInitializationData((List)initializationData);
        byte[] spsNalDataWithStartCode = (byte[])initializationData.get(1);
        NalUnitUtil.H265SpsData spsData = NalUnitUtil.parseH265SpsNalUnit((byte[])spsNalDataWithStartCode, (int)NalUnitUtil.NAL_START_CODE.length, (int)spsNalDataWithStartCode.length);
        formatBuilder.setPixelWidthHeightRatio(spsData.pixelWidthHeightRatio);
        formatBuilder.setHeight(spsData.height).setWidth(spsData.width);
        formatBuilder.setCodecs(CodecSpecificDataUtil.buildHevcCodecString((int)spsData.generalProfileSpace, (boolean)spsData.generalTierFlag, (int)spsData.generalProfileIdc, (int)spsData.generalProfileCompatibilityFlags, (int[])spsData.constraintBytes, (int)spsData.generalLevelIdc));
    }

    private static Uri extractTrackUri(RtspHeaders rtspHeaders, Uri sessionUri, String controlAttributeString) {
        Uri controlAttributeUri = Uri.parse((String)controlAttributeString);
        if (controlAttributeUri.isAbsolute()) {
            return controlAttributeUri;
        }
        if (!TextUtils.isEmpty((CharSequence)rtspHeaders.get("Content-Base"))) {
            sessionUri = Uri.parse((String)rtspHeaders.get("Content-Base"));
        } else if (!TextUtils.isEmpty((CharSequence)rtspHeaders.get("Content-Location"))) {
            sessionUri = Uri.parse((String)rtspHeaders.get("Content-Location"));
        }
        if (controlAttributeString.equals(GENERIC_CONTROL_ATTR)) {
            return sessionUri;
        }
        return sessionUri.buildUpon().appendEncodedPath(controlAttributeString).build();
    }
}

