/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp.reader;

import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.rtsp.RtpPacket;
import androidx.media3.exoplayer.rtsp.RtpPayloadFormat;
import androidx.media3.exoplayer.rtsp.reader.RtpPayloadReader;
import androidx.media3.exoplayer.rtsp.reader.RtpReaderUtils;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpH263Reader
implements RtpPayloadReader {
    private static final String TAG = "RtpH263Reader";
    private static final int MEDIA_CLOCK_FREQUENCY = 90000;
    private static final int I_VOP = 0;
    private static final int PICTURE_START_CODE = 128;
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private int fragmentedSampleSizeBytes;
    private int previousSequenceNumber;
    private int width;
    private int height;
    private boolean isKeyFrame;
    private boolean isOutputFormatSet;
    private long startTimeOffsetUs;
    private long fragmentedSampleTimeUs;
    private boolean gotFirstPacketOfH263Frame;

    public RtpH263Reader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.previousSequenceNumber = -1;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 2);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
        Assertions.checkState((this.firstReceivedTimestamp == -9223372036854775807L ? 1 : 0) != 0);
        this.firstReceivedTimestamp = timestamp;
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        boolean pBitIsSet;
        Assertions.checkStateNotNull((Object)this.trackOutput);
        int currentPosition = data.getPosition();
        int header = data.readUnsignedShort();
        boolean bl = pBitIsSet = (header & 0x400) > 0;
        if ((header & 0x200) != 0 || (header & 0x1F8) != 0 || (header & 7) != 0) {
            Log.w((String)TAG, (String)"Dropping packet: video reduncancy coding is not supported, packet header VRC, or PLEN or PEBIT is non-zero");
            return;
        }
        if (pBitIsSet) {
            if (this.gotFirstPacketOfH263Frame && this.fragmentedSampleSizeBytes > 0) {
                this.outputSampleMetadataForFragmentedPackets();
            }
            this.gotFirstPacketOfH263Frame = true;
            int payloadStartCode = data.peekUnsignedByte() & 0xFC;
            if (payloadStartCode < 128) {
                Log.w((String)TAG, (String)"Picture start Code (PSC) missing, dropping packet.");
                return;
            }
            data.getData()[currentPosition] = 0;
            data.getData()[currentPosition + 1] = 0;
            data.setPosition(currentPosition);
        } else if (this.gotFirstPacketOfH263Frame) {
            int expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber);
            if (sequenceNumber < expectedSequenceNumber) {
                Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d. Dropping packet.", (Object[])new Object[]{expectedSequenceNumber, sequenceNumber}));
                return;
            }
        } else {
            Log.w((String)TAG, (String)"First payload octet of the H263 packet is not the beginning of a new H263 partition, Dropping current packet.");
            return;
        }
        if (this.fragmentedSampleSizeBytes == 0) {
            this.parseVopHeader(data, this.isOutputFormatSet);
            if (!this.isOutputFormatSet && this.isKeyFrame) {
                if (this.width != this.payloadFormat.format.width || this.height != this.payloadFormat.format.height) {
                    this.trackOutput.format(this.payloadFormat.format.buildUpon().setWidth(this.width).setHeight(this.height).build());
                }
                this.isOutputFormatSet = true;
            }
        }
        int fragmentSize = data.bytesLeft();
        this.trackOutput.sampleData(data, fragmentSize);
        this.fragmentedSampleSizeBytes += fragmentSize;
        this.fragmentedSampleTimeUs = RtpReaderUtils.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp, 90000);
        if (rtpMarker) {
            this.outputSampleMetadataForFragmentedPackets();
        }
        this.previousSequenceNumber = sequenceNumber;
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.fragmentedSampleSizeBytes = 0;
        this.startTimeOffsetUs = timeUs;
    }

    private void parseVopHeader(ParsableByteArray data, boolean gotResolution) {
        int currentPosition = data.getPosition();
        long shortVideoHeader = data.readUnsignedInt();
        if ((shortVideoHeader >> 10 & 0x3FL) == 32L) {
            int header = data.peekUnsignedByte();
            int vopType = header >> 1 & 1;
            if (!gotResolution && vopType == 0) {
                int sourceFormat = header >> 2 & 7;
                if (sourceFormat == 1) {
                    this.width = 128;
                    this.height = 96;
                } else {
                    this.width = 176 << sourceFormat - 2;
                    this.height = 144 << sourceFormat - 2;
                }
            }
            data.setPosition(currentPosition);
            this.isKeyFrame = vopType == 0;
            return;
        }
        data.setPosition(currentPosition);
        this.isKeyFrame = false;
    }

    private void outputSampleMetadataForFragmentedPackets() {
        ((TrackOutput)Assertions.checkNotNull((Object)this.trackOutput)).sampleMetadata(this.fragmentedSampleTimeUs, this.isKeyFrame ? 1 : 0, this.fragmentedSampleSizeBytes, 0, null);
        this.fragmentedSampleSizeBytes = 0;
        this.fragmentedSampleTimeUs = -9223372036854775807L;
        this.isKeyFrame = false;
        this.gotFirstPacketOfH263Frame = false;
    }
}

